/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.container.ContainerProvider;

public class ImmutableSessionActivationNotifier<CC, S, L, SC>
implements SessionActivationNotifier {
    private final ContainerProvider<CC, S, L, SC> provider;
    private final S session;
    private final Collection<Object> attributes;
    private final AtomicBoolean active = new AtomicBoolean(false);

    public ImmutableSessionActivationNotifier(ContainerProvider<CC, S, L, SC> provider, S session, Collection<Object> attributes) {
        this.provider = provider;
        this.session = session;
        this.attributes = attributes;
    }

    @Override
    public void prePassivate() {
        if (this.active.compareAndSet(true, false)) {
            this.notify(arg_0 -> this.provider.getPrePassivateEventNotifier(arg_0));
        }
    }

    @Override
    public void postActivate() {
        if (this.active.compareAndSet(false, true)) {
            this.notify(arg_0 -> this.provider.getPostActivateEventNotifier(arg_0));
        }
    }

    private void notify(Function<L, Consumer<S>> factory) {
        List<Object> listeners = this.attributes.stream().map(attribute -> this.provider.getSessionEventListener(this.session, attribute)).filter(Optional::isPresent).map(Optional::get).toList();
        if (!listeners.isEmpty()) {
            for (Object listener : listeners) {
                ((Consumer)factory.apply(listener)).accept(this.session);
            }
        }
    }
}

