/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Predicate;
import org.wildfly.clustering.session.cache.metadata.AbstractImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.ImmutableSessionMetaDataEntry;

public class DefaultImmutableSessionMetaData
extends AbstractImmutableSessionMetaData {
    private static final Predicate<Duration> MORTAL = Predicate.not(Duration::isZero);
    private final ImmutableSessionMetaDataEntry entry;

    public DefaultImmutableSessionMetaData(ImmutableSessionMetaDataEntry entry) {
        this.entry = entry;
    }

    public Instant getCreationTime() {
        return this.entry.getCreationTime();
    }

    public Optional<Instant> getLastAccessStartTime() {
        return !this.entry.isNew() ? Optional.of(this.entry.getLastAccessStartTime().get()) : Optional.empty();
    }

    public Optional<Instant> getLastAccessEndTime() {
        return !this.entry.isNew() ? Optional.of(this.entry.getLastAccessEndTime().get()) : Optional.empty();
    }

    public Optional<Duration> getMaxIdle() {
        return Optional.of(this.entry.getMaxIdle()).filter(MORTAL);
    }
}

