/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.server.offset.OffsetValue;
import org.wildfly.clustering.session.cache.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.MutableSessionMetaDataValues;

public interface MutableSessionMetaDataOffsetValues
extends MutableSessionMetaDataValues {
    public static <C> MutableSessionMetaDataOffsetValues from(ContextualSessionMetaDataEntry<C> entry) {
        final OffsetValue maxIdle = OffsetValue.from((Duration)entry.getMaxIdle());
        final OffsetValue lastAccessStartTime = entry.getLastAccessStartTime().rebase();
        final OffsetValue lastAccessEndTime = entry.getLastAccessEndTime().rebase();
        return new MutableSessionMetaDataOffsetValues(){

            @Override
            public OffsetValue<Duration> getMaxIdle() {
                return maxIdle;
            }

            @Override
            public OffsetValue<Instant> getLastAccessStartTime() {
                return lastAccessStartTime;
            }

            @Override
            public OffsetValue<Instant> getLastAccessEndTime() {
                return lastAccessEndTime;
            }
        };
    }

    public OffsetValue<Duration> getMaxIdle();

    public OffsetValue<Instant> getLastAccessStartTime();

    public OffsetValue<Instant> getLastAccessEndTime();
}

