/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.server.util.Supplied;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;

public class DefaultSessionCreationMetaDataEntry<C>
implements SessionCreationMetaDataEntry<C> {
    private final Instant creationTime;
    private volatile Duration timeout = Duration.ZERO;
    private final Supplied<C> context = Supplied.cached();

    public DefaultSessionCreationMetaDataEntry(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Duration getMaxIdle() {
        return this.timeout;
    }

    @Override
    public void setMaxIdle(Duration timeout) {
        this.timeout = timeout.isNegative() ? Duration.ZERO : timeout;
    }

    @Override
    public Supplied<C> getContext() {
        return this.context;
    }

    public SessionCreationMetaDataEntry<C> remap(java.util.function.Supplier<Offset<Duration>> timeoutOffset) {
        DefaultSessionCreationMetaDataEntry<C> result = new DefaultSessionCreationMetaDataEntry<C>(this.creationTime);
        result.setMaxIdle((Duration)timeoutOffset.get().apply((Object)this.timeout));
        result.getContext().get((java.util.function.Supplier)Supplier.of((Object)this.context.get((java.util.function.Supplier)Supplier.empty())));
        return result;
    }

    public String toString() {
        return Map.of("creation-time", this.creationTime, "timeout", this.timeout).toString();
    }
}

