/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.cache.Cache;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.session.cache.user.CacheableUser;
import org.wildfly.clustering.session.cache.user.CachedUser;
import org.wildfly.clustering.session.cache.user.DecoratedUserManager;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserManager;

public class CachedUserManager<C, T, D, S>
extends DecoratedUserManager<C, T, D, S> {
    static final System.Logger LOGGER = System.getLogger(CachedUserManager.class.getName());
    private final Cache<String, CacheableUser<C, T, D, S>> cache;
    private final BiFunction<String, Runnable, CacheableUser<C, T, D, S>> findUser = (id, closeTask) -> Optional.ofNullable(manager.findUser(id)).map(user -> new CachedUser(user, (Runnable)closeTask)).orElse(null);

    public CachedUserManager(UserManager<C, T, D, S> manager, CacheFactory cacheFactory) {
        super(manager);
        this.cache = cacheFactory.createCache((java.util.function.Consumer)Consumer.empty(), (java.util.function.Consumer)Consumer.close().compose(Supplier::get));
    }

    @Override
    public User<C, T, D, S> createUser(String id, C context) {
        BiFunction<String, Runnable, CacheableUser> createUser = (userId, closeTask) -> new CachedUser(super.createUser((String)userId, context), (Runnable)closeTask);
        return (User)this.cache.computeIfAbsent((Object)id, createUser);
    }

    @Override
    public User<C, T, D, S> findUser(String id) {
        return (User)this.cache.computeIfAbsent((Object)id, this.findUser);
    }
}

