/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.ManagedSession;

public class ManagedSessionTestCase {
    private final Session<String> attachedSession = (Session)Mockito.mock(Session.class);
    private final Session<String> detachedSession = (Session)Mockito.mock(Session.class);
    private final Session<String> session = new ManagedSession(this.attachedSession, this.detachedSession);

    @Test
    public void getId() {
        String attachedId = "attached";
        String detachedId = "detached";
        ((Session)Mockito.doReturn((Object)attachedId).when(this.attachedSession)).getId();
        ((Session)Mockito.doReturn((Object)detachedId).when(this.detachedSession)).getId();
        Assertions.assertThat((String)this.session.getId()).isSameAs((Object)attachedId);
        ((Session)Mockito.verify(this.attachedSession)).getId();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).getId();
        this.session.close();
        ((Session)Mockito.verify(this.attachedSession)).close();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).close();
        Assertions.assertThat((String)this.session.getId()).isSameAs((Object)detachedId);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
        this.session.close();
        ((Session)Mockito.verify(this.detachedSession)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
    }

    @Test
    public void getContext() {
        String attachedContext = "attached";
        String detachedContext = "detached";
        ((Session)Mockito.doReturn((Object)attachedContext).when(this.attachedSession)).getContext();
        ((Session)Mockito.doReturn((Object)detachedContext).when(this.detachedSession)).getContext();
        Assertions.assertThat((String)((String)this.session.getContext())).isSameAs((Object)attachedContext);
        ((Session)Mockito.verify(this.attachedSession)).getContext();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).getContext();
        this.session.close();
        ((Session)Mockito.verify(this.attachedSession)).close();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).close();
        Assertions.assertThat((String)((String)this.session.getContext())).isSameAs((Object)detachedContext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
        this.session.close();
        ((Session)Mockito.verify(this.detachedSession)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
    }

    @Test
    public void isValid() {
        ((Session)Mockito.doReturn((Object)true).when(this.attachedSession)).isValid();
        ((Session)Mockito.doReturn((Object)false).when(this.detachedSession)).isValid();
        Assertions.assertThat((boolean)this.session.isValid()).isTrue();
        ((Session)Mockito.verify(this.attachedSession)).isValid();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).isValid();
        this.session.close();
        ((Session)Mockito.verify(this.attachedSession)).close();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).close();
        Assertions.assertThat((boolean)this.session.isValid()).isFalse();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
        this.session.close();
        ((Session)Mockito.verify(this.detachedSession)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
    }

    @Test
    public void getMetaData() {
        SessionMetaData attachedMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionMetaData detachedMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        ((Session)Mockito.doReturn((Object)attachedMetaData).when(this.attachedSession)).getMetaData();
        ((Session)Mockito.doReturn((Object)detachedMetaData).when(this.detachedSession)).getMetaData();
        Assertions.assertThat((Object)this.session.getMetaData()).isSameAs((Object)attachedMetaData);
        ((Session)Mockito.verify(this.attachedSession)).getMetaData();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).getMetaData();
        this.session.close();
        ((Session)Mockito.verify(this.attachedSession)).close();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).close();
        Assertions.assertThat((Object)this.session.getMetaData()).isSameAs((Object)detachedMetaData);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
        this.session.close();
        ((Session)Mockito.verify(this.detachedSession)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
    }

    @Test
    public void getAttributes() {
        Map attachedAttributes = (Map)Mockito.mock(Map.class);
        Map detachedAttributes = (Map)Mockito.mock(Map.class);
        ((Session)Mockito.doReturn((Object)attachedAttributes).when(this.attachedSession)).getAttributes();
        ((Session)Mockito.doReturn((Object)detachedAttributes).when(this.detachedSession)).getAttributes();
        Assertions.assertThat((Map)this.session.getAttributes()).isSameAs((Object)attachedAttributes);
        ((Session)Mockito.verify(this.attachedSession)).getAttributes();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).getAttributes();
        this.session.close();
        ((Session)Mockito.verify(this.attachedSession)).close();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).close();
        Assertions.assertThat((Map)this.session.getAttributes()).isSameAs((Object)detachedAttributes);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
        this.session.close();
        ((Session)Mockito.verify(this.detachedSession)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
    }

    @Test
    public void invalidate() {
        this.session.invalidate();
        ((Session)Mockito.verify(this.attachedSession)).invalidate();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).invalidate();
        this.session.close();
        ((Session)Mockito.verify(this.attachedSession)).close();
        ((Session)Mockito.verify(this.detachedSession, (VerificationMode)Mockito.never())).close();
        this.session.invalidate();
        ((Session)Mockito.verify(this.detachedSession)).invalidate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
        this.session.close();
        ((Session)Mockito.verify(this.detachedSession)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attachedSession});
    }
}

