/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;

public class CoarseSessionAttributesTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeAttribute() {
        Map map = (Map)Mockito.mock(Map.class);
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        org.wildfly.clustering.function.Predicate marshallable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        org.wildfly.clustering.function.Predicate immutable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        SessionActivationNotifier notifier = (SessionActivationNotifier)Mockito.mock(SessionActivationNotifier.class);
        UUID existing = UUID.randomUUID();
        try (CoarseSessionAttributes attributes = new CoarseSessionAttributes(map, mutator, (Predicate)marshallable, (Predicate)immutable, notifier);){
            Mockito.verifyNoInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).postActivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            ((Map)Mockito.doReturn((Object)existing).when((Object)map)).remove("remove");
            Assertions.assertThat((Object)attributes.remove((Object)"remove")).isSameAs((Object)existing);
            ((Map)Mockito.verify((Object)map)).remove("remove");
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
        }
        catch (Throwable throwable) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((Runnable)Mockito.verify((Object)mutator)).run();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            throw throwable;
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
        Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
        Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
        ((Runnable)Mockito.verify((Object)mutator)).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
        ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeMissingAttribute() {
        Map map = (Map)Mockito.mock(Map.class);
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        org.wildfly.clustering.function.Predicate marshallable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        org.wildfly.clustering.function.Predicate immutable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        SessionActivationNotifier notifier = (SessionActivationNotifier)Mockito.mock(SessionActivationNotifier.class);
        try (CoarseSessionAttributes attributes = new CoarseSessionAttributes(map, mutator, (Predicate)marshallable, (Predicate)immutable, notifier);){
            Mockito.verifyNoInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).postActivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            Assertions.assertThat((Object)attributes.remove((Object)"remove")).isNull();
            Assertions.assertThat((Object)attributes.put((Object)"put", null)).isNull();
            ((Map)Mockito.verify((Object)map)).remove("remove");
            ((Map)Mockito.verify((Object)map)).remove("put");
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
        }
        catch (Throwable throwable) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            throw throwable;
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
        Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
        Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
        ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setAttribute() {
        Map map = (Map)Mockito.mock(Map.class);
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        org.wildfly.clustering.function.Predicate marshallable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        org.wildfly.clustering.function.Predicate immutable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        SessionActivationNotifier notifier = (SessionActivationNotifier)Mockito.mock(SessionActivationNotifier.class);
        UUID initial = UUID.randomUUID();
        UUID replacement = UUID.randomUUID();
        try (CoarseSessionAttributes attributes = new CoarseSessionAttributes(map, mutator, (Predicate)marshallable, (Predicate)immutable, notifier);){
            Mockito.verifyNoInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).postActivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            ((org.wildfly.clustering.function.Predicate)Mockito.doReturn((Object)true).when((Object)marshallable)).test((Object)initial);
            ((org.wildfly.clustering.function.Predicate)Mockito.doReturn((Object)true).when((Object)marshallable)).test((Object)replacement);
            ((Map)Mockito.doReturn((Object)initial).when((Object)map)).put("value", replacement);
            Assertions.assertThat((Object)attributes.put((Object)"value", (Object)initial)).isNull();
            Assertions.assertThat((Object)attributes.put((Object)"value", (Object)replacement)).isSameAs((Object)initial);
            ((Map)Mockito.verify((Object)map)).put("value", initial);
            ((Map)Mockito.verify((Object)map)).put("value", replacement);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            ((org.wildfly.clustering.function.Predicate)Mockito.verify((Object)marshallable)).test((Object)initial);
            ((org.wildfly.clustering.function.Predicate)Mockito.verify((Object)marshallable)).test((Object)replacement);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
        }
        catch (Throwable throwable) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            ((Runnable)Mockito.verify((Object)mutator)).run();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            throw throwable;
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
        ((Runnable)Mockito.verify((Object)mutator)).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{marshallable});
        Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
        ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setUnmarshallableAttribute() {
        Map map = (Map)Mockito.mock(Map.class);
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        org.wildfly.clustering.function.Predicate marshallable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        org.wildfly.clustering.function.Predicate immutable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        SessionActivationNotifier notifier = (SessionActivationNotifier)Mockito.mock(SessionActivationNotifier.class);
        UUID unmarshallable = UUID.randomUUID();
        try (CoarseSessionAttributes attributes = new CoarseSessionAttributes(map, mutator, (Predicate)marshallable, (Predicate)immutable, notifier);){
            Mockito.verifyNoInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).postActivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            ((org.wildfly.clustering.function.Predicate)Mockito.doReturn((Object)false).when((Object)marshallable)).test((Object)unmarshallable);
            Assertions.assertThatThrownBy(() -> CoarseSessionAttributesTestCase.lambda$setUnmarshallableAttribute$0((SessionAttributes)attributes, unmarshallable)).isInstanceOf(IllegalArgumentException.class);
            Mockito.verifyNoInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            ((org.wildfly.clustering.function.Predicate)Mockito.verify((Object)marshallable)).test((Object)unmarshallable);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
        }
        catch (Throwable throwable) {
            Mockito.verifyNoInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            throw throwable;
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{map});
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{marshallable});
        Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
        ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getAttributeNames() {
        Map map = (Map)Mockito.mock(Map.class);
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        org.wildfly.clustering.function.Predicate marshallable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        org.wildfly.clustering.function.Predicate immutable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        SessionActivationNotifier notifier = (SessionActivationNotifier)Mockito.mock(SessionActivationNotifier.class);
        Set<String> names = Set.of("foo", "bar");
        try (CoarseSessionAttributes attributes = new CoarseSessionAttributes(map, mutator, (Predicate)marshallable, (Predicate)immutable, notifier);){
            Mockito.verifyNoInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).postActivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            ((Map)Mockito.doReturn(names).when((Object)map)).keySet();
            Assertions.assertThat((Collection)attributes.keySet()).containsExactlyInAnyOrderElementsOf(names);
            ((Map)Mockito.verify((Object)map)).keySet();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
        }
        catch (Throwable throwable) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            throw throwable;
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
        Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
        Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
        ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getMutableAttribute() {
        Map map = (Map)Mockito.mock(Map.class);
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        org.wildfly.clustering.function.Predicate marshallable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        org.wildfly.clustering.function.Predicate immutable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        SessionActivationNotifier notifier = (SessionActivationNotifier)Mockito.mock(SessionActivationNotifier.class);
        UUID existent = UUID.randomUUID();
        UUID another = UUID.randomUUID();
        try (CoarseSessionAttributes attributes = new CoarseSessionAttributes(map, mutator, (Predicate)marshallable, (Predicate)immutable, notifier);){
            Mockito.verifyNoInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).postActivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            ((Map)Mockito.doReturn((Object)existent).when((Object)map)).get("existing");
            ((Map)Mockito.doReturn((Object)another).when((Object)map)).get("another");
            Assertions.assertThat((Object)attributes.get((Object)"existing")).isSameAs((Object)existent);
            Assertions.assertThat((Object)attributes.get((Object)"another")).isSameAs((Object)another);
            Assertions.assertThat((Object)attributes.get((Object)"missing")).isNull();
            ((Map)Mockito.verify((Object)map)).get("existing");
            ((Map)Mockito.verify((Object)map)).get("another");
            ((Map)Mockito.verify((Object)map)).get("missing");
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            ((org.wildfly.clustering.function.Predicate)Mockito.verify((Object)immutable)).test((Object)existent);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{immutable});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
        }
        catch (Throwable throwable) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            ((Runnable)Mockito.verify((Object)mutator)).run();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            throw throwable;
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
        ((Runnable)Mockito.verify((Object)mutator)).run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mutator});
        Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{immutable});
        ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getImmutableAttribute() {
        Map map = (Map)Mockito.mock(Map.class);
        Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
        org.wildfly.clustering.function.Predicate marshallable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        org.wildfly.clustering.function.Predicate immutable = (org.wildfly.clustering.function.Predicate)Mockito.mock(org.wildfly.clustering.function.Predicate.class);
        SessionActivationNotifier notifier = (SessionActivationNotifier)Mockito.mock(SessionActivationNotifier.class);
        UUID existent = UUID.randomUUID();
        try (CoarseSessionAttributes attributes = new CoarseSessionAttributes(map, mutator, (Predicate)marshallable, (Predicate)immutable, notifier);){
            Mockito.verifyNoInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).postActivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            ((Map)Mockito.doReturn((Object)existent).when((Object)map)).get("existing");
            ((org.wildfly.clustering.function.Predicate)Mockito.doReturn((Object)true).when((Object)immutable)).test((Object)existent);
            Assertions.assertThat((Object)attributes.get((Object)"existing")).isSameAs((Object)existent);
            Assertions.assertThat((Object)attributes.get((Object)"missing")).isNull();
            ((Map)Mockito.verify((Object)map)).get("existing");
            ((Map)Mockito.verify((Object)map)).get("missing");
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            ((org.wildfly.clustering.function.Predicate)Mockito.verify((Object)immutable)).test((Object)existent);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{immutable});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
        }
        catch (Throwable throwable) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
            Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
            Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{immutable});
            ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
            throw throwable;
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
        Mockito.verifyNoInteractions((Object[])new Object[]{marshallable});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{immutable});
        ((SessionActivationNotifier)Mockito.verify((Object)notifier)).prePassivate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{notifier});
    }

    private static /* synthetic */ void lambda$setUnmarshallableAttribute$0(SessionAttributes attributes, UUID unmarshallable) throws Throwable {
        attributes.put((Object)"unmarshallable", (Object)unmarshallable);
    }
}

