/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.wildfly.clustering.server.offset.OffsetValue;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.ImmutableSessionMetaDataEntry;

public abstract class AbstractImmutableSessionMetaDataTestCase {
    void testCreationTime(ImmutableSessionMetaDataEntry entry, ImmutableSessionMetaData metaData) {
        Instant expected = Instant.now();
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)expected).when((Object)entry)).getCreationTime();
        Instant result = metaData.getCreationTime();
        Assertions.assertThat((Instant)result).isSameAs((Object)expected);
    }

    void testLastAccessStartTime(ImmutableSessionMetaDataEntry entry, ImmutableSessionMetaData metaData) {
        Instant expected = Instant.now();
        OffsetValue lastAccessStartTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)false).when((Object)entry)).isNew();
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessStartTime).when((Object)entry)).getLastAccessStartTime();
        ((OffsetValue)Mockito.doReturn((Object)expected).when((Object)lastAccessStartTime)).get();
        Assertions.assertThat((Optional)metaData.getLastAccessStartTime()).hasValue((Object)expected);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)true).when((Object)entry)).isNew();
        Assertions.assertThat((Optional)metaData.getLastAccessStartTime()).isEmpty();
    }

    void testLastAccessEndTime(ImmutableSessionMetaDataEntry entry, ImmutableSessionMetaData metaData) {
        Instant expected = Instant.now();
        OffsetValue lastAccessEndTime = (OffsetValue)Mockito.mock(OffsetValue.class);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)false).when((Object)entry)).isNew();
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)lastAccessEndTime).when((Object)entry)).getLastAccessEndTime();
        ((OffsetValue)Mockito.doReturn((Object)expected).when((Object)lastAccessEndTime)).get();
        Assertions.assertThat((Optional)metaData.getLastAccessEndTime()).hasValue((Object)expected);
        Assertions.assertThat((Optional)metaData.getLastAccessTime()).hasValue((Object)expected);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)true).when((Object)entry)).isNew();
        Assertions.assertThat((Optional)metaData.getLastAccessEndTime()).isEmpty();
    }

    void testTimeout(ImmutableSessionMetaDataEntry entry, ImmutableSessionMetaData metaData) {
        Duration expected = Duration.ofMinutes(60L);
        ((ImmutableSessionMetaDataEntry)Mockito.doReturn((Object)Duration.ZERO, (Object[])new Object[]{expected}).when((Object)entry)).getMaxIdle();
        Assertions.assertThat((Optional)metaData.getMaxIdle()).isEmpty();
        Assertions.assertThat((Optional)metaData.getMaxIdle()).hasValue((Object)expected);
    }
}

