/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionCreationMetaData;

public abstract class AbstractImmutableSessionMetaDataTestCase {
    void isExpired(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        ((ImmutableSessionCreationMetaData)Mockito.doReturn((Object)Instant.now().minus(Duration.ofMinutes(10L))).when((Object)creationMetaData)).getCreationTime();
        ((ImmutableSessionCreationMetaData)Mockito.doReturn((Object)Duration.ofMinutes(10L), (Object[])new Object[]{Duration.ofMinutes(5L).minus(Duration.ofSeconds(1L, 1L)), Duration.ZERO}).when((Object)creationMetaData)).getMaxIdle();
        ((ImmutableSessionAccessMetaData)Mockito.doReturn((Object)Duration.ofMinutes(5L)).when((Object)accessMetaData)).getSinceCreationDuration();
        ((ImmutableSessionAccessMetaData)Mockito.doReturn((Object)Duration.ofSeconds(1L)).when((Object)accessMetaData)).getLastAccessDuration();
        Assertions.assertThat((boolean)metaData.isExpired()).isFalse();
        Assertions.assertThat((boolean)metaData.isExpired()).isTrue();
        Assertions.assertThat((boolean)metaData.isExpired()).isFalse();
    }

    void getCreationTime(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        Instant expected = Instant.now();
        Mockito.when((Object)creationMetaData.getCreationTime()).thenReturn((Object)expected);
        Instant result = metaData.getCreationTime();
        Assertions.assertThat((Instant)result).isSameAs((Object)expected);
    }

    void getLastAccessStartTime(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        ((ImmutableSessionAccessMetaData)Mockito.doReturn((Object)Duration.ZERO).when((Object)accessMetaData)).getLastAccessDuration();
        Assertions.assertThat((Optional)metaData.getLastAccessStartTime()).isEmpty();
        Instant now = Instant.now();
        Duration sinceCreation = Duration.ofSeconds(10L);
        ((ImmutableSessionAccessMetaData)Mockito.doReturn((Object)Duration.ofSeconds(1L)).when((Object)accessMetaData)).getLastAccessDuration();
        ((ImmutableSessionCreationMetaData)Mockito.doReturn((Object)now.minus(sinceCreation)).when((Object)creationMetaData)).getCreationTime();
        ((ImmutableSessionAccessMetaData)Mockito.doReturn((Object)sinceCreation).when((Object)accessMetaData)).getSinceCreationDuration();
        Assertions.assertThat((Optional)metaData.getLastAccessStartTime()).hasValue((Object)now);
    }

    void getLastAccessEndTime(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        ((ImmutableSessionAccessMetaData)Mockito.doReturn((Object)Duration.ZERO).when((Object)accessMetaData)).getLastAccessDuration();
        Assertions.assertThat((Optional)metaData.getLastAccessEndTime()).isEmpty();
        Instant now = Instant.now();
        Duration sinceCreation = Duration.ofSeconds(10L);
        Duration lastAccess = Duration.ofSeconds(1L);
        ((ImmutableSessionAccessMetaData)Mockito.doReturn((Object)Duration.ofSeconds(1L)).when((Object)accessMetaData)).getLastAccessDuration();
        ((ImmutableSessionCreationMetaData)Mockito.doReturn((Object)now.minus(sinceCreation).minus(lastAccess)).when((Object)creationMetaData)).getCreationTime();
        ((ImmutableSessionAccessMetaData)Mockito.doReturn((Object)sinceCreation).when((Object)accessMetaData)).getSinceCreationDuration();
        ((ImmutableSessionAccessMetaData)Mockito.doReturn((Object)lastAccess).when((Object)accessMetaData)).getLastAccessDuration();
        Assertions.assertThat((Optional)metaData.getLastAccessEndTime()).hasValue((Object)now);
    }

    void getMaxIdle(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData, ImmutableSessionMetaData metaData) {
        Duration expected = Duration.ofMinutes(30L);
        ((ImmutableSessionCreationMetaData)Mockito.doReturn((Object)Duration.ZERO, (Object[])new Object[]{expected}).when((Object)creationMetaData)).getMaxIdle();
        Assertions.assertThat((Optional)metaData.getMaxIdle()).isEmpty();
        Assertions.assertThat((Optional)metaData.getMaxIdle()).hasValue((Object)expected);
    }
}

