/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.mockito.Mockito;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.AbstractImmutableSessionMetaDataTestCase;
import org.wildfly.clustering.session.cache.metadata.fine.CompositeSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaData;

public class CompositeSessionMetaDataTestCase
extends AbstractImmutableSessionMetaDataTestCase {
    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void isExpired(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Runnable mutator, InvalidatableSessionMetaData metaData) {
        super.isExpired((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void getCreationTime(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Runnable mutator, InvalidatableSessionMetaData metaData) {
        super.getCreationTime((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void getLastAccessStartTime(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Runnable mutator, InvalidatableSessionMetaData metaData) {
        super.getLastAccessStartTime((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void getLastAccessEndTime(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Runnable mutator, InvalidatableSessionMetaData metaData) {
        super.getLastAccessEndTime((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void getMaxInactiveInterval(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Runnable mutator, InvalidatableSessionMetaData metaData) {
        super.getMaxIdle((ImmutableSessionCreationMetaData)creationMetaData, (ImmutableSessionAccessMetaData)accessMetaData, (ImmutableSessionMetaData)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void setLastAccessed(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Runnable mutator, InvalidatableSessionMetaData metaData) {
        Instant creationTime;
        Instant startTime = creationTime = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        Instant endTime = startTime.plus(Duration.ofMillis(500L));
        Mockito.when((Object)creationMetaData.getCreationTime()).thenReturn((Object)creationTime);
        metaData.setLastAccess(startTime, endTime);
        ((SessionAccessMetaData)Mockito.verify((Object)accessMetaData)).setLastAccessDuration(Duration.ZERO, Duration.ofSeconds(1L));
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
        Mockito.reset((Object[])new SessionAccessMetaData[]{accessMetaData});
        Duration sinceCreated = Duration.ofSeconds(10L);
        startTime = creationTime.plus(sinceCreated);
        endTime = startTime.plus(Duration.ofMillis(500L));
        metaData.setLastAccess(startTime, endTime);
        ((SessionAccessMetaData)Mockito.verify((Object)accessMetaData)).setLastAccessDuration(sinceCreated, Duration.ofSeconds(1L));
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
        Mockito.reset((Object[])new SessionAccessMetaData[]{accessMetaData});
        sinceCreated = Duration.ofSeconds(20L);
        endTime = startTime = creationTime.plus(sinceCreated);
        metaData.setLastAccess(startTime, endTime);
        ((SessionAccessMetaData)Mockito.verify((Object)accessMetaData)).setLastAccessDuration(sinceCreated, Duration.ofSeconds(1L));
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void setMaxInactiveInterval(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Runnable mutator, InvalidatableSessionMetaData metaData) {
        Duration duration = Duration.ZERO;
        metaData.setMaxIdle(duration);
        ((SessionCreationMetaData)Mockito.verify((Object)creationMetaData)).setMaxIdle(duration);
        Mockito.verifyNoInteractions((Object[])new Object[]{mutator});
    }

    @ParameterizedTest
    @ArgumentsSource(value=Parameters.class)
    public void close(SessionCreationMetaData creationMetaData, SessionAccessMetaData accessMetaData, Runnable mutator, InvalidatableSessionMetaData metaData) {
        metaData.close();
        ((Runnable)Mockito.verify((Object)mutator)).run();
    }

    static class Parameters
    implements ArgumentsProvider {
        Parameters() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            SessionCreationMetaData creationMetaData = (SessionCreationMetaData)Mockito.mock(SessionCreationMetaData.class);
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)Mockito.mock(SessionAccessMetaData.class);
            Runnable mutator = (Runnable)Mockito.mock(Runnable.class);
            CompositeSessionMetaData metaData = new CompositeSessionMetaData(creationMetaData, accessMetaData, mutator);
            return Stream.of(Arguments.of((Object[])new Object[]{creationMetaData, accessMetaData, mutator, metaData}));
        }
    }
}

