/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.BiCacheEntryLocator;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.ImmutableSessionFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.ImmutableSessionAttributesFactory;

public interface ImmutableSessionFactory<MV, AV>
extends ImmutableSessionFactoryConfiguration<MV, AV>,
BiCacheEntryLocator<String, MV, AV> {
    default public Map.Entry<CompletionStage<MV>, CompletionStage<AV>> findEntry(String id) {
        CompletionStage metaDataStage = this.getSessionMetaDataFactory().findValueAsync(id);
        ImmutableSessionAttributesFactory attributesFactory = this.getSessionAttributesFactory();
        CompletionStage attributesStage = this.getCacheProperties().isLockOnRead() ? metaDataStage.thenCompose(metaData -> metaData != null ? attributesFactory.findValueAsync(id) : CompletableFuture.completedStage(null)) : attributesFactory.findValueAsync(id);
        return Map.entry(metaDataStage, attributesStage);
    }

    default public Map.Entry<CompletionStage<MV>, CompletionStage<AV>> tryEntry(String id) {
        CompletionStage metaDataStage = this.getSessionMetaDataFactory().tryValueAsync(id);
        ImmutableSessionAttributesFactory attributesFactory = this.getSessionAttributesFactory();
        CompletionStage attributesStage = this.getCacheProperties().isLockOnRead() ? metaDataStage.thenCompose(metaData -> metaData != null ? attributesFactory.findValueAsync(id) : CompletableFuture.completedStage(null)) : attributesFactory.tryValueAsync(id);
        return Map.entry(metaDataStage, attributesStage);
    }

    default public ImmutableSession createImmutableSession(String id, Map.Entry<MV, AV> entry) {
        MV metaDataValue = entry.getKey();
        AV attributesValue = entry.getValue();
        if (metaDataValue == null || attributesValue == null) {
            return null;
        }
        ImmutableSessionMetaData metaData = this.getSessionMetaDataFactory().createImmutableSessionMetaData(id, metaDataValue);
        Map<String, Object> attributes = this.getSessionAttributesFactory().createImmutableSessionAttributes(id, attributesValue);
        return this.createImmutableSession(id, metaData, attributes);
    }

    public ImmutableSession createImmutableSession(String var1, ImmutableSessionMetaData var2, Map<String, Object> var3);
}

