/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.fine;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.container.ContainerProvider;

public class ImmutableSessionAttributeActivationNotifier<CC, S, L, SC>
implements SessionAttributeActivationNotifier {
    private final Function<Supplier<L>, Optional<L>> prePassivateListenerFactory;
    private final Function<Supplier<L>, Optional<L>> postActivateListenerFactory;
    private final ContainerProvider<CC, S, L, SC> provider;
    private final S session;
    private final Map<Supplier<L>, Optional<L>> listeners = new ConcurrentHashMap<Supplier<L>, Optional<L>>();

    public ImmutableSessionAttributeActivationNotifier(ContainerProvider<CC, S, L, SC> provider, S session) {
        this.provider = provider;
        this.session = session;
        this.prePassivateListenerFactory = new SessionActivationListenerFactory<CC, S, L, SC>(provider, true);
        this.postActivateListenerFactory = new SessionActivationListenerFactory<CC, S, L, SC>(provider, false);
    }

    @Override
    public void prePassivate(Object object) {
        this.notify(object, this.prePassivateListenerFactory, arg_0 -> this.provider.getPrePassivateEventNotifier(arg_0));
    }

    @Override
    public void postActivate(Object object) {
        this.notify(object, this.postActivateListenerFactory, arg_0 -> this.provider.getPostActivateEventNotifier(arg_0));
    }

    private void notify(Object object, Function<Supplier<L>, Optional<L>> listenerFactory, Function<L, java.util.function.Consumer<S>> notifierFactory) {
        this.provider.getSessionEventListener(this.session, object).ifPresent(listener -> {
            SessionActivationListenerKey<Object> reference = new SessionActivationListenerKey<Object>(listener);
            this.listeners.computeIfAbsent(reference, listenerFactory);
            ((java.util.function.Consumer)notifierFactory.apply(listener)).accept(this.session);
        });
    }

    private static class SessionActivationListenerFactory<CC, S, L, SC>
    implements Function<Supplier<L>, Optional<L>> {
        private final ContainerProvider<CC, S, L, SC> provider;
        private final AtomicBoolean active;

        SessionActivationListenerFactory(ContainerProvider<CC, S, L, SC> provider, boolean active) {
            this.provider = provider;
            this.active = new AtomicBoolean(active);
        }

        @Override
        public Optional<L> apply(Supplier<L> listener) {
            Consumer prePassivate = session -> {
                if (this.active.compareAndSet(true, false)) {
                    this.provider.getPrePassivateEventNotifier(listener.get()).accept(session);
                }
            };
            Consumer postActivate = session -> {
                if (this.active.compareAndSet(false, true)) {
                    this.provider.getPostActivateEventNotifier(listener.get()).accept(session);
                }
            };
            return this.provider.getSessionEventListener((java.util.function.Consumer)prePassivate, (java.util.function.Consumer)postActivate);
        }
    }

    private static class SessionActivationListenerKey<L>
    implements Supplier<L> {
        private final L listener;

        SessionActivationListenerKey(L listener) {
            this.listener = listener;
        }

        public L get() {
            return this.listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof SessionActivationListenerKey)) {
                return false;
            }
            SessionActivationListenerKey reference = (SessionActivationListenerKey)object;
            return this.listener == reference.listener;
        }
    }
}

