/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionMetaData;

public class DetachedSessionMetaData<C, B extends Batch>
implements SessionMetaData {
    private final Supplier<B> batchFactory;
    private final Supplier<Session<C>> sessionFactory;

    public DetachedSessionMetaData(Supplier<B> batchFactory, Supplier<Session<C>> sessionFactory) {
        this.batchFactory = batchFactory;
        this.sessionFactory = sessionFactory;
    }

    public boolean isExpired() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            boolean bl;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    bl = session.getMetaData().isExpired();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return bl;
        }
    }

    public Instant getCreationTime() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Instant instant;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    instant = session.getMetaData().getCreationTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    public Optional<Instant> getLastAccessStartTime() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Optional optional;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    optional = session.getMetaData().getLastAccessStartTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return optional;
        }
    }

    public Optional<Instant> getLastAccessEndTime() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Optional optional;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    optional = session.getMetaData().getLastAccessEndTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return optional;
        }
    }

    public Optional<Duration> getMaxIdle() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Optional optional;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    optional = session.getMetaData().getMaxIdle();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return optional;
        }
    }

    public void setMaxIdle(Duration duration) {
        try (Batch batch = (Batch)this.batchFactory.get();
             Session<C> session = this.sessionFactory.get();){
            session.getMetaData().setMaxIdle(duration);
        }
    }

    public void setLastAccess(Instant startTime, Instant endTime) {
        throw new IllegalStateException();
    }
}

