/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.session.cache.metadata.coarse.DefaultSessionMetaDataEntry;

public enum DefaultSessionMetaDataEntryMarshaller implements ProtoStreamMarshaller<DefaultSessionMetaDataEntry<Object>>
{
    INSTANCE;

    private static final Instant DEFAULT_CREATION_TIME;
    private static final Duration DEFAULT_TIMEOUT;
    private static final Offset<Instant> DEFAULT_LAST_ACCESS_START_TIME_OFFSET;
    private static final Offset<Instant> DEFAULT_LAST_ACCESS_END_TIME_OFFSET;
    private static final int CREATION_TIME_INDEX = 1;
    private static final int TIMEOUT_INDEX = 2;
    private static final int LAST_ACCESS_START_TIME_OFFSET_INDEX = 3;
    private static final int LAST_ACCESS_END_TIME_OFFSET_INDEX = 4;

    public DefaultSessionMetaDataEntry<Object> readFrom(ProtoStreamReader reader) throws IOException {
        Instant creationTime = DEFAULT_CREATION_TIME;
        Duration timeout = DEFAULT_TIMEOUT;
        Offset lastAccessStartTimeOffset = DEFAULT_LAST_ACCESS_START_TIME_OFFSET;
        Offset lastAccessEndTimeOffset = DEFAULT_LAST_ACCESS_END_TIME_OFFSET;
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    creationTime = (Instant)reader.readObject(Instant.class);
                    continue block6;
                }
                case 2: {
                    timeout = (Duration)reader.readObject(Duration.class);
                    continue block6;
                }
                case 3: {
                    lastAccessStartTimeOffset = (Offset)reader.readObject(lastAccessStartTimeOffset.getClass());
                    continue block6;
                }
                case 4: {
                    lastAccessEndTimeOffset = (Offset)reader.readObject(lastAccessEndTimeOffset.getClass());
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        DefaultSessionMetaDataEntry<Object> metaData = new DefaultSessionMetaDataEntry<Object>(creationTime);
        metaData.setMaxIdle(timeout);
        metaData.getLastAccessStartTime().setOffset(lastAccessStartTimeOffset);
        metaData.getLastAccessEndTime().setOffset(lastAccessEndTimeOffset);
        return metaData;
    }

    public void writeTo(ProtoStreamWriter writer, DefaultSessionMetaDataEntry<Object> metaData) throws IOException {
        Offset lastAccessEndTimeOffset;
        Offset lastAccessStartTimeOffset;
        Duration timeout;
        Instant creationTime = metaData.getCreationTime();
        if (!creationTime.equals(DEFAULT_CREATION_TIME)) {
            writer.writeObject(1, (Object)creationTime);
        }
        if (!(timeout = metaData.getMaxIdle()).equals(DEFAULT_TIMEOUT)) {
            writer.writeObject(2, (Object)timeout);
        }
        if (!(lastAccessStartTimeOffset = metaData.getLastAccessStartTime().getOffset()).equals(DEFAULT_LAST_ACCESS_START_TIME_OFFSET)) {
            writer.writeObject(3, (Object)lastAccessStartTimeOffset);
        }
        if (!(lastAccessEndTimeOffset = metaData.getLastAccessEndTime().getOffset()).equals(DEFAULT_LAST_ACCESS_END_TIME_OFFSET)) {
            writer.writeObject(4, (Object)lastAccessEndTimeOffset);
        }
    }

    public Class<? extends DefaultSessionMetaDataEntry<Object>> getJavaClass() {
        return DefaultSessionMetaDataEntry.class;
    }

    static {
        DEFAULT_CREATION_TIME = Instant.EPOCH;
        DEFAULT_TIMEOUT = Duration.ofMinutes(30L);
        DEFAULT_LAST_ACCESS_START_TIME_OFFSET = Offset.forInstant((Duration)Duration.ZERO);
        DEFAULT_LAST_ACCESS_END_TIME_OFFSET = Offset.forInstant((Duration)ChronoUnit.SECONDS.getDuration());
    }
}

