/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.coarse;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.server.offset.Offset;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntryFunction;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntryOffsets;

public enum SessionMetaDataEntryFunctionMarshaller implements ProtoStreamMarshaller<SessionMetaDataEntryFunction<Object>>
{
    INSTANCE;

    private static final int TIMEOUT_OFFSET_INDEX = 1;
    private static final int LAST_ACCESS_START_TIME_OFFSET_INDEX = 2;
    private static final int LAST_ACCESS_END_TIME_OFFSET_INDEX = 3;

    public Class<? extends SessionMetaDataEntryFunction<Object>> getJavaClass() {
        return SessionMetaDataEntryFunction.class;
    }

    public SessionMetaDataEntryFunction<Object> readFrom(ProtoStreamReader reader) throws IOException {
        final AtomicReference<Offset> timeoutOffset = new AtomicReference<Offset>(Offset.forDuration((Duration)Duration.ZERO));
        final AtomicReference<Offset> lastAccessStartTimeOffset = new AtomicReference<Offset>(Offset.forInstant((Duration)Duration.ZERO));
        final AtomicReference<Offset> lastAccessEndTimeOffset = new AtomicReference<Offset>(Offset.forInstant((Duration)Duration.ZERO));
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    timeoutOffset.setPlain((Offset)reader.readObject(timeoutOffset.getPlain().getClass()));
                    continue block5;
                }
                case 2: {
                    lastAccessStartTimeOffset.setPlain((Offset)reader.readObject(lastAccessStartTimeOffset.getPlain().getClass()));
                    continue block5;
                }
                case 3: {
                    lastAccessEndTimeOffset.setPlain((Offset)reader.readObject(lastAccessEndTimeOffset.getPlain().getClass()));
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return new SessionMetaDataEntryFunction<Object>(new SessionMetaDataEntryOffsets(){
            final /* synthetic */ SessionMetaDataEntryFunctionMarshaller this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Offset<Duration> getMaxIdleOffset() {
                return (Offset)timeoutOffset.getPlain();
            }

            @Override
            public Offset<Instant> getLastAccessStartTimeOffset() {
                return (Offset)lastAccessStartTimeOffset.getPlain();
            }

            @Override
            public Offset<Instant> getLastAccessEndTimeOffset() {
                return (Offset)lastAccessEndTimeOffset.getPlain();
            }
        });
    }

    public void writeTo(ProtoStreamWriter writer, SessionMetaDataEntryFunction<Object> function) throws IOException {
        Offset<Instant> lastAccessEndTimeOffset;
        Offset<Instant> lastAccessStartTimeOffset;
        SessionMetaDataEntryOffsets operand = (SessionMetaDataEntryOffsets)function.getOperand();
        Offset<Duration> timeoutOffset = operand.getMaxIdleOffset();
        if (!timeoutOffset.isZero()) {
            writer.writeObject(1, timeoutOffset);
        }
        if (!(lastAccessStartTimeOffset = operand.getLastAccessStartTimeOffset()).isZero()) {
            writer.writeObject(2, lastAccessStartTimeOffset);
        }
        if (!(lastAccessEndTimeOffset = operand.getLastAccessEndTimeOffset()).isZero()) {
            writer.writeObject(3, lastAccessEndTimeOffset);
        }
    }
}

