/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Predicate;
import org.wildfly.clustering.session.cache.metadata.AbstractImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionCreationMetaData;

public class CompositeImmutableSessionMetaData
extends AbstractImmutableSessionMetaData {
    private static final Predicate<Duration> MORTAL = Predicate.not(Duration::isZero);
    private final ImmutableSessionCreationMetaData creationMetaData;
    private final ImmutableSessionAccessMetaData accessMetaData;

    public CompositeImmutableSessionMetaData(ImmutableSessionCreationMetaData creationMetaData, ImmutableSessionAccessMetaData accessMetaData) {
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
    }

    public Optional<Duration> getMaxIdle() {
        return Optional.of(this.creationMetaData.getMaxIdle()).filter(MORTAL);
    }

    public Instant getCreationTime() {
        return this.creationMetaData.getCreationTime();
    }

    public Optional<Instant> getLastAccessStartTime() {
        return !this.accessMetaData.getLastAccessDuration().isZero() ? Optional.of(this.getCreationTime().plus(this.accessMetaData.getSinceCreationDuration())) : Optional.empty();
    }

    public Optional<Instant> getLastAccessEndTime() {
        return this.getLastAccessStartTime().map(start -> start.plus(this.accessMetaData.getLastAccessDuration()));
    }
}

