/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;

public abstract class AbstractHttpSessionTestCase<S extends ImmutableSession, M extends ImmutableSessionMetaData> {
    final S session;
    final M metaData;
    final ServletContext context;
    final HttpSession subject;
    final Random random = new Random();

    AbstractHttpSessionTestCase(Class<S> sessionClass, Class<M> metaDataClass, BiFunction<S, ServletContext, HttpSession> factory) {
        this.session = (ImmutableSession)Mockito.mock(sessionClass);
        this.metaData = (ImmutableSessionMetaData)Mockito.mock(metaDataClass);
        this.context = (ServletContext)Mockito.mock(ServletContext.class);
        this.subject = factory.apply(this.session, this.context);
    }

    @Test
    public void getServletContext() {
        Assertions.assertThat((Object)this.subject.getServletContext()).isSameAs((Object)this.context);
    }

    @Test
    public void getId() {
        String expected = "foo";
        ((ImmutableSession)Mockito.doReturn((Object)expected).when(this.session)).getId();
        Assertions.assertThat((String)this.subject.getId()).isSameAs((Object)expected);
    }

    @Test
    public void getCreationTime() {
        Instant now = Instant.now();
        ((ImmutableSession)Mockito.doReturn(this.metaData).when(this.session)).getMetaData();
        ((ImmutableSessionMetaData)Mockito.doReturn((Object)now).when(this.metaData)).getCreationTime();
        Assertions.assertThat((long)this.subject.getCreationTime()).isEqualTo(now.toEpochMilli());
    }

    @Test
    public void getMaxInactiveInterval() {
        Duration timeout = Duration.ofSeconds(this.random.nextInt(Short.MAX_VALUE));
        ((ImmutableSession)Mockito.doReturn(this.metaData).when(this.session)).getMetaData();
        ((ImmutableSessionMetaData)Mockito.doReturn(Optional.empty(), (Object[])new Object[]{Optional.of(timeout)}).when(this.metaData)).getMaxIdle();
        Assertions.assertThat((int)this.subject.getMaxInactiveInterval()).isEqualTo(0);
        Assertions.assertThat((int)this.subject.getMaxInactiveInterval()).isEqualTo(timeout.getSeconds());
    }

    @Test
    public void getLastAccessedTime() {
        Instant expected = Instant.now();
        Instant created = expected.minus(Duration.ofMinutes(1L));
        ((ImmutableSession)Mockito.doReturn(this.metaData).when(this.session)).getMetaData();
        ((ImmutableSessionMetaData)Mockito.doReturn((Object)created).when(this.metaData)).getCreationTime();
        ((ImmutableSessionMetaData)Mockito.doReturn(Optional.empty(), (Object[])new Object[]{Optional.of(expected)}).when(this.metaData)).getLastAccessStartTime();
        Assertions.assertThat((long)this.subject.getLastAccessedTime()).isEqualTo(created.toEpochMilli());
        Assertions.assertThat((long)this.subject.getLastAccessedTime()).isEqualTo(expected.toEpochMilli());
    }

    @Test
    public void isNew() {
        ((ImmutableSession)Mockito.doReturn(this.metaData).when(this.session)).getMetaData();
        ((ImmutableSessionMetaData)Mockito.doReturn(Optional.empty(), (Object[])new Object[]{Optional.of(Instant.now())}).when(this.metaData)).getLastAccessTime();
        Assertions.assertThat((boolean)this.subject.isNew()).isTrue();
        Assertions.assertThat((boolean)this.subject.isNew()).isFalse();
    }

    @Test
    public void getAttributeNames() {
        Map<String, UUID> attributes = Map.of("foo", UUID.randomUUID(), "bar", UUID.randomUUID());
        ((ImmutableSession)Mockito.doReturn(attributes).when(this.session)).getAttributes();
        Assertions.assertThat(Collections.list(this.subject.getAttributeNames())).containsExactlyInAnyOrderElementsOf(attributes.keySet());
    }

    @Test
    public void getAttribute() {
        Map<String, UUID> attributes = Map.of("foo", UUID.randomUUID(), "bar", UUID.randomUUID());
        ((ImmutableSession)Mockito.doReturn(attributes).when(this.session)).getAttributes();
        for (Map.Entry<String, UUID> entry : attributes.entrySet()) {
            Assertions.assertThat((Object)this.subject.getAttribute(entry.getKey())).isSameAs((Object)entry.getValue());
        }
        Assertions.assertThat((Object)this.subject.getAttribute("baz")).isNull();
    }

    @Test
    public void setMaxInactiveInterval() {
        this.subject.setMaxInactiveInterval(this.random.nextInt(Short.MAX_VALUE));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.session});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.context});
    }

    @Test
    public void setAttribute() {
        this.subject.setAttribute("foo", (Object)UUID.randomUUID());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.session});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.context});
    }

    @Test
    public void removeAttribute() {
        this.subject.removeAttribute("foo");
        Mockito.verifyNoInteractions((Object[])new Object[]{this.session});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.context});
    }

    @Test
    public void invalidate() {
        this.subject.invalidate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.session});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.context});
    }
}

