/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.session.container.servlet.AbstractHttpSession;

public class DetachableHttpSession
extends AbstractHttpSession {
    private final Supplier<HttpSession> reader;
    private final Supplier<HttpSession> writer;

    DetachableHttpSession(HttpSession attachedSession, HttpSession detachedSession) {
        AtomicReference<HttpSession> reference = new AtomicReference<HttpSession>(attachedSession);
        this.reader = reference::get;
        Supplier detached = Supplier.of((Object)detachedSession);
        this.writer = detached.thenApply((java.util.function.Function)Function.of(reference::set, (java.util.function.Supplier)detached));
    }

    public String getId() {
        return ((HttpSession)this.reader.get()).getId();
    }

    public ServletContext getServletContext() {
        return ((HttpSession)this.reader.get()).getServletContext();
    }

    public boolean isNew() {
        return ((HttpSession)this.reader.get()).isNew();
    }

    public long getCreationTime() {
        return ((HttpSession)this.reader.get()).getCreationTime();
    }

    public long getLastAccessedTime() {
        return ((HttpSession)this.reader.get()).getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return ((HttpSession)this.reader.get()).getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int interval) {
        ((HttpSession)this.writer.get()).setMaxInactiveInterval(interval);
    }

    public Object getAttribute(String name) {
        return ((HttpSession)this.reader.get()).getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return ((HttpSession)this.reader.get()).getAttributeNames();
    }

    public void setAttribute(String name, Object value) {
        ((HttpSession)this.writer.get()).setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        ((HttpSession)this.writer.get()).removeAttribute(name);
    }

    public void invalidate() {
        ((HttpSession)this.writer.get()).invalidate();
    }
}

