/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionEvent;
import java.util.Optional;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.container.ContainerProvider;
import org.wildfly.clustering.session.container.servlet.DetachableHttpSession;
import org.wildfly.clustering.session.container.servlet.ImmutableHttpSession;
import org.wildfly.clustering.session.container.servlet.MutableHttpSession;

public class ServletContainerProvider<C>
implements ContainerProvider.SessionAttributeEventListener<ServletContext, HttpSession, HttpSessionActivationListener, C> {
    public String getId(ServletContext context) {
        return context.getVirtualServerName() + context.getContextPath();
    }

    public HttpSession getDetachableSession(SessionManager<C> manager, ImmutableSession session, ServletContext context) {
        HttpSession detached = this.getDetachedSession(manager, session.getId(), context);
        return detached != null ? new DetachableHttpSession(new ImmutableHttpSession(session, context), detached) : null;
    }

    public HttpSession getDetachedSession(SessionManager<C> manager, String id, ServletContext context) {
        Session detached = manager.getDetachedSession(id);
        return detached != null ? new MutableHttpSession(detached, context) : null;
    }

    public Class<HttpSessionActivationListener> getSessionEventListenerClass() {
        return HttpSessionActivationListener.class;
    }

    public Consumer<HttpSession> getPrePassivateEventNotifier(HttpSessionActivationListener listener) {
        Consumer eventNotifier = arg_0 -> ((HttpSessionActivationListener)listener).sessionWillPassivate(arg_0);
        return eventNotifier.compose(HttpSessionEvent::new);
    }

    public Consumer<HttpSession> getPostActivateEventNotifier(HttpSessionActivationListener listener) {
        Consumer eventNotifier = arg_0 -> ((HttpSessionActivationListener)listener).sessionDidActivate(arg_0);
        return eventNotifier.compose(HttpSessionEvent::new);
    }

    public Optional<HttpSessionActivationListener> getSessionEventListener(final java.util.function.Consumer<HttpSession> prePassivateEventNotifier, final java.util.function.Consumer<HttpSession> postActivateEventNotifier) {
        return Optional.of(new HttpSessionActivationListener(){
            final /* synthetic */ ServletContainerProvider this$0;
            {
                this.this$0 = this$0;
            }

            public void sessionWillPassivate(HttpSessionEvent event) {
                prePassivateEventNotifier.accept(event.getSession());
            }

            public void sessionDidActivate(HttpSessionEvent event) {
                postActivateEventNotifier.accept(event.getSession());
            }
        });
    }

    public String toString() {
        return "Jakarta Servlet 6.0";
    }
}

