/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container.servlet;

import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.container.servlet.AbstractHttpSessionTestCase;
import org.wildfly.clustering.session.container.servlet.MutableHttpSession;

public class MutableHttpSessionTestCase
extends AbstractHttpSessionTestCase<Session<Void>, SessionMetaData> {
    public MutableHttpSessionTestCase() {
        super(Session.class, SessionMetaData.class, MutableHttpSession::new);
    }

    @Override
    public void setMaxInactiveInterval() {
        int timeout = this.random.nextInt(Short.MAX_VALUE);
        ArgumentCaptor capturedTimeout = ArgumentCaptor.forClass(Duration.class);
        ((Session)Mockito.doReturn((Object)this.metaData).when((Object)((Session)this.session))).getMetaData();
        this.subject.setMaxInactiveInterval(timeout);
        ((SessionMetaData)Mockito.verify((Object)((SessionMetaData)this.metaData))).setMaxIdle((Duration)capturedTimeout.capture());
        Assertions.assertThat((Duration)((Duration)capturedTimeout.getValue())).hasSeconds((long)timeout);
    }

    @Override
    public void setAttribute() {
        String key = "foo";
        UUID value = UUID.randomUUID();
        Map attributes = (Map)Mockito.mock(Map.class);
        ((Session)Mockito.doReturn((Object)attributes).when((Object)((Session)this.session))).getAttributes();
        this.subject.setAttribute(key, (Object)value);
        ((Map)Mockito.verify((Object)attributes)).put(key, value);
    }

    @Override
    public void removeAttribute() {
        String key = "foo";
        Map attributes = (Map)Mockito.mock(Map.class);
        ((Session)Mockito.doReturn((Object)attributes).when((Object)((Session)this.session))).getAttributes();
        this.subject.removeAttribute(key);
        ((Map)Mockito.verify((Object)attributes)).remove(key);
    }

    @Override
    public void invalidate() {
        this.subject.invalidate();
        ((Session)Mockito.verify((Object)((Session)this.session))).invalidate();
    }
}

