/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.session.container.servlet.DetachableHttpSession;

public class DetachableHttpSessionTestCase {
    private final HttpSession attached = (HttpSession)Mockito.mock(HttpSession.class);
    private final HttpSession detached = (HttpSession)Mockito.mock(HttpSession.class);
    private final HttpSession session = new DetachableHttpSession(this.attached, this.detached);
    private final Random random = new Random();

    @Test
    public void getServletContext() {
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        ((HttpSession)Mockito.doReturn((Object)context).when((Object)this.attached)).getServletContext();
        ((HttpSession)Mockito.doReturn((Object)context).when((Object)this.detached)).getServletContext();
        Assertions.assertThat((Object)this.session.getServletContext()).isSameAs((Object)context);
        Assertions.assertThat((Object)this.session.getServletContext()).isSameAs((Object)context);
        ((HttpSession)Mockito.verify((Object)this.attached, (VerificationMode)Mockito.times((int)2))).getServletContext();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.detached});
        this.session.invalidate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).invalidate();
        Assertions.assertThat((Object)this.session.getServletContext()).isSameAs((Object)context);
        Assertions.assertThat((Object)this.session.getServletContext()).isSameAs((Object)context);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).getServletContext();
    }

    @Test
    public void getId() {
        String expected = "foo";
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.attached)).getId();
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.detached)).getId();
        Assertions.assertThat((String)this.session.getId()).isSameAs((Object)expected);
        Assertions.assertThat((String)this.session.getId()).isSameAs((Object)expected);
        ((HttpSession)Mockito.verify((Object)this.attached, (VerificationMode)Mockito.times((int)2))).getId();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.detached});
        this.session.invalidate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).invalidate();
        Assertions.assertThat((String)this.session.getId()).isSameAs((Object)expected);
        Assertions.assertThat((String)this.session.getId()).isSameAs((Object)expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).getId();
    }

    @Test
    public void getCreationTime() {
        long expected = System.currentTimeMillis();
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.attached)).getCreationTime();
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.detached)).getCreationTime();
        Assertions.assertThat((long)this.session.getCreationTime()).isEqualTo(expected);
        Assertions.assertThat((long)this.session.getCreationTime()).isEqualTo(expected);
        ((HttpSession)Mockito.verify((Object)this.attached, (VerificationMode)Mockito.times((int)2))).getCreationTime();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.detached});
        this.session.invalidate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).invalidate();
        Assertions.assertThat((long)this.session.getCreationTime()).isEqualTo(expected);
        Assertions.assertThat((long)this.session.getCreationTime()).isEqualTo(expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).getCreationTime();
    }

    @Test
    public void getMaxInactiveInterval() {
        int expected = this.random.nextInt(Short.MAX_VALUE);
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.attached)).getMaxInactiveInterval();
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.detached)).getMaxInactiveInterval();
        Assertions.assertThat((int)this.session.getMaxInactiveInterval()).isEqualTo(expected);
        Assertions.assertThat((int)this.session.getMaxInactiveInterval()).isEqualTo(expected);
        ((HttpSession)Mockito.verify((Object)this.attached, (VerificationMode)Mockito.times((int)2))).getMaxInactiveInterval();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.detached});
        this.session.setMaxInactiveInterval(expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).setMaxInactiveInterval(expected);
        Assertions.assertThat((int)this.session.getMaxInactiveInterval()).isEqualTo(expected);
        Assertions.assertThat((int)this.session.getMaxInactiveInterval()).isEqualTo(expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).getMaxInactiveInterval();
    }

    @Test
    public void getLastAccessedTime() {
        long expected = System.currentTimeMillis();
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.attached)).getLastAccessedTime();
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.detached)).getLastAccessedTime();
        Assertions.assertThat((long)this.session.getLastAccessedTime()).isEqualTo(expected);
        Assertions.assertThat((long)this.session.getLastAccessedTime()).isEqualTo(expected);
        ((HttpSession)Mockito.verify((Object)this.attached, (VerificationMode)Mockito.times((int)2))).getLastAccessedTime();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.detached});
        this.session.invalidate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).invalidate();
        Assertions.assertThat((long)this.session.getLastAccessedTime()).isEqualTo(expected);
        Assertions.assertThat((long)this.session.getLastAccessedTime()).isEqualTo(expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).getLastAccessedTime();
    }

    @Test
    public void isNew() {
        boolean expected = this.random.nextBoolean();
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.attached)).isNew();
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.detached)).isNew();
        Assertions.assertThat((boolean)this.session.isNew()).isEqualTo(expected);
        Assertions.assertThat((boolean)this.session.isNew()).isEqualTo(expected);
        ((HttpSession)Mockito.verify((Object)this.attached, (VerificationMode)Mockito.times((int)2))).isNew();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.detached});
        this.session.invalidate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).invalidate();
        Assertions.assertThat((boolean)this.session.isNew()).isEqualTo(expected);
        Assertions.assertThat((boolean)this.session.isNew()).isEqualTo(expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).isNew();
    }

    @Test
    public void getAttributeNames() {
        Enumeration<String> expected = Collections.enumeration(List.of("foo"));
        ((HttpSession)Mockito.doReturn(expected).when((Object)this.attached)).getAttributeNames();
        ((HttpSession)Mockito.doReturn(expected).when((Object)this.detached)).getAttributeNames();
        Assertions.assertThat((Object)this.session.getAttributeNames()).isSameAs(expected);
        Assertions.assertThat((Object)this.session.getAttributeNames()).isSameAs(expected);
        ((HttpSession)Mockito.verify((Object)this.attached, (VerificationMode)Mockito.times((int)2))).getAttributeNames();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.detached});
        this.session.removeAttribute("foo");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).removeAttribute("foo");
        Assertions.assertThat((Object)this.session.getAttributeNames()).isSameAs(expected);
        Assertions.assertThat((Object)this.session.getAttributeNames()).isSameAs(expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).getAttributeNames();
    }

    @Test
    public void getAttribute() {
        String name = "foo";
        UUID expected = UUID.randomUUID();
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.attached)).getAttribute(name);
        ((HttpSession)Mockito.doReturn((Object)expected).when((Object)this.detached)).getAttribute(name);
        Assertions.assertThat((Object)this.session.getAttribute(name)).isSameAs((Object)expected);
        Assertions.assertThat((Object)this.session.getAttribute(name)).isSameAs((Object)expected);
        ((HttpSession)Mockito.verify((Object)this.attached, (VerificationMode)Mockito.times((int)2))).getAttribute(name);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.detached});
        this.session.setAttribute(name, (Object)expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).setAttribute(name, (Object)expected);
        Assertions.assertThat((Object)this.session.getAttribute(name)).isSameAs((Object)expected);
        Assertions.assertThat((Object)this.session.getAttribute(name)).isSameAs((Object)expected);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).getAttribute(name);
    }

    @Test
    public void setMaxInactiveInterval() {
        int expected = this.random.nextInt(Short.MAX_VALUE);
        this.session.setMaxInactiveInterval(expected);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).setMaxInactiveInterval(expected);
        this.session.setMaxInactiveInterval(expected);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).setMaxInactiveInterval(expected);
    }

    @Test
    public void setAttribute() {
        String name = "foo";
        UUID value = UUID.randomUUID();
        this.session.setAttribute(name, (Object)value);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).setAttribute(name, (Object)value);
        this.session.setAttribute(name, (Object)value);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).setAttribute(name, (Object)value);
    }

    @Test
    public void removeAttribute() {
        String name = "foo";
        this.session.removeAttribute(name);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).removeAttribute(name);
        this.session.removeAttribute(name);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).removeAttribute(name);
    }

    @Test
    public void invalidate() {
        this.session.invalidate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached)).invalidate();
        this.session.invalidate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.attached});
        ((HttpSession)Mockito.verify((Object)this.detached, (VerificationMode)Mockito.times((int)2))).invalidate();
    }

    @Test
    public void getAccessor() {
        this.session.getAccessor().access(session -> Assertions.assertThat((Object)session).isSameAs((Object)this.detached));
    }
}

