/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.session.container.servlet.AbstractHttpSession;

public class DetachableHttpSession
extends AbstractHttpSession {
    private final org.wildfly.clustering.function.Supplier<HttpSession> reader;
    private final org.wildfly.clustering.function.Supplier<HttpSession> writer;
    private final HttpSession.Accessor accessor;

    DetachableHttpSession(HttpSession attachedSession, final HttpSession detachedSession) {
        AtomicReference<HttpSession> reference = new AtomicReference<HttpSession>(attachedSession);
        this.reader = reference::get;
        org.wildfly.clustering.function.Supplier detached = org.wildfly.clustering.function.Supplier.of((Object)detachedSession);
        this.writer = detached.thenApply((Function)org.wildfly.clustering.function.Function.of(reference::set, (Supplier)detached));
        this.accessor = new HttpSession.Accessor(){
            final /* synthetic */ DetachableHttpSession this$0;
            {
                this.this$0 = this$0;
            }

            public void access(Consumer<HttpSession> consumer) {
                consumer.accept(detachedSession);
            }
        };
    }

    public String getId() {
        return ((HttpSession)this.reader.get()).getId();
    }

    public ServletContext getServletContext() {
        return ((HttpSession)this.reader.get()).getServletContext();
    }

    public boolean isNew() {
        return ((HttpSession)this.reader.get()).isNew();
    }

    public long getCreationTime() {
        return ((HttpSession)this.reader.get()).getCreationTime();
    }

    public long getLastAccessedTime() {
        return ((HttpSession)this.reader.get()).getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return ((HttpSession)this.reader.get()).getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int interval) {
        ((HttpSession)this.writer.get()).setMaxInactiveInterval(interval);
    }

    public Object getAttribute(String name) {
        return ((HttpSession)this.reader.get()).getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return ((HttpSession)this.reader.get()).getAttributeNames();
    }

    public void setAttribute(String name, Object value) {
        ((HttpSession)this.writer.get()).setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        ((HttpSession)this.writer.get()).removeAttribute(name);
    }

    public void invalidate() {
        ((HttpSession)this.writer.get()).invalidate();
    }

    public HttpSession.Accessor getAccessor() {
        return this.accessor;
    }
}

