/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container.servlet;

import jakarta.servlet.ServletContext;
import java.time.Duration;
import java.util.Collections;
import java.util.Enumeration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.container.servlet.AbstractHttpSession;

public class ImmutableHttpSession
extends AbstractHttpSession {
    private final ImmutableSession session;
    private final ServletContext context;

    ImmutableHttpSession(ImmutableSession session, ServletContext context) {
        this.session = session;
        this.context = context;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getId() {
        return this.session.getId();
    }

    public long getCreationTime() {
        return this.session.getMetaData().getCreationTime().toEpochMilli();
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getMetaData().getMaxIdle().orElse(Duration.ZERO).getSeconds();
    }

    public long getLastAccessedTime() {
        return this.session.getMetaData().getLastAccessStartTime().orElse(this.session.getMetaData().getCreationTime()).toEpochMilli();
    }

    public boolean isNew() {
        return this.session.getMetaData().getLastAccessTime().isEmpty();
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.session.getAttributes().keySet());
    }

    public Object getAttribute(String name) {
        return this.session.getAttributes().get(name);
    }

    public void setMaxInactiveInterval(int interval) {
    }

    public void setAttribute(String name, Object value) {
    }

    public void removeAttribute(String name) {
    }

    public void invalidate() {
    }
}

