/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container.servlet;

import jakarta.servlet.ServletContext;
import java.time.Duration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.container.servlet.ImmutableHttpSession;

public class MutableHttpSession
extends ImmutableHttpSession {
    private final Session<?> session;

    MutableHttpSession(Session<?> session, ServletContext context) {
        super((ImmutableSession)session, context);
        this.session = session;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.session.getMetaData().setMaxIdle(Duration.ofSeconds(interval));
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.session.getAttributes().put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.session.getAttributes().remove(name);
    }

    @Override
    public void invalidate() {
        this.session.invalidate();
    }
}

