/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.container;

import java.util.Optional;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManager;

public interface ContainerProvider<CC, S, L, SC> {
    public String getId(CC var1);

    default public S getDetachableSession(SessionManager<SC> manager, ImmutableSession session, CC context) {
        return this.getDetachedSession(manager, session.getId(), context);
    }

    public S getDetachedSession(SessionManager<SC> var1, String var2, CC var3);

    public Optional<L> getSessionEventListener(S var1, Object var2);

    public java.util.function.Consumer<S> getPrePassivateEventNotifier(L var1);

    public java.util.function.Consumer<S> getPostActivateEventNotifier(L var1);

    public Optional<L> getSessionEventListener(java.util.function.Consumer<S> var1, java.util.function.Consumer<S> var2);

    public static interface SessionAttributeEventListener<CC, S, L, SC>
    extends ContainerProvider<CC, S, L, SC> {
        @Override
        default public Optional<L> getSessionEventListener(S session, Object attribute) {
            Class<L> listenerClass = this.getSessionEventListenerClass();
            return Optional.ofNullable(attribute).filter(listenerClass::isInstance).map(listenerClass::cast);
        }

        public Class<L> getSessionEventListenerClass();
    }

    public static interface VoidEventListener<CC, S, SC>
    extends ContainerProvider<CC, S, Void, SC> {
        @Override
        default public Optional<Void> getSessionEventListener(S session, Object attribute) {
            return Optional.empty();
        }

        @Override
        default public java.util.function.Consumer<S> getPostActivateEventNotifier(Void listener) {
            return Consumer.empty();
        }

        @Override
        default public java.util.function.Consumer<S> getPrePassivateEventNotifier(Void listener) {
            return Consumer.empty();
        }

        @Override
        default public Optional<Void> getSessionEventListener(java.util.function.Consumer<S> prePassivateEventNotifier, java.util.function.Consumer<S> postActivateEventNotifier) {
            return Optional.empty();
        }
    }
}

