/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jgroups.Address;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.ForkChannelFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactoryProvider;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.MockSessionSpecificationProvider;
import org.wildfly.clustering.session.cache.SessionManagerFactoryProvider;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerParameters;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class InfinispanSessionManagerFactoryProvider<C>
implements SessionManagerFactoryProvider<C, TransactionBatch> {
    private static final String CONTAINER_NAME = "container";
    private static final String SERVER_NAME = "server";
    private static final String DEPLOYMENT_NAME = "test.war";
    private final InfinispanSessionManagerParameters parameters;
    private final ChannelCommandDispatcherFactoryProvider dispatcherFactoryProvider;
    private final EmbeddedCacheManager manager;

    public InfinispanSessionManagerFactoryProvider(InfinispanSessionManagerParameters parameters, String memberName) throws Exception {
        this.parameters = parameters;
        this.dispatcherFactoryProvider = new ChannelCommandDispatcherFactoryProvider(parameters.getClusterName(), memberName);
        this.manager = new EmbeddedCacheManagerFactory((Function)new ForkChannelFactory(this.dispatcherFactoryProvider.getChannel()), parameters.getClusterName(), memberName).apply(CONTAINER_NAME, InfinispanSessionManagerFactoryConfiguration.class.getClassLoader());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(parameters.getCacheMode());
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        builder.transaction().transactionMode(parameters.getTransactionMode());
        if (parameters.getTransactionMode().isTransactional()) {
            builder.transaction().transactionManagerLookup(() -> EmbeddedTransactionManager.getInstance());
            builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        }
        this.manager.defineConfiguration(DEPLOYMENT_NAME, builder.build());
    }

    public <SC> SessionManagerFactory<C, SC, TransactionBatch> createSessionManagerFactory(final Supplier<SC> contextFactory) {
        EmbeddedCacheManagerCommandDispatcherFactory commandDispatcherFactory = new EmbeddedCacheManagerCommandDispatcherFactory((EmbeddedCacheManagerCommandDispatcherFactoryConfiguration)new ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){

            public EmbeddedCacheManager getCacheContainer() {
                return InfinispanSessionManagerFactoryProvider.this.manager;
            }

            public GroupCommandDispatcherFactory<Address, ChannelGroupMember> getCommandDispatcherFactory() {
                return InfinispanSessionManagerFactoryProvider.this.dispatcherFactoryProvider.getCommandDispatcherFactory();
            }
        });
        SessionManagerFactoryConfiguration managerFactoryConfiguration = new SessionManagerFactoryConfiguration<SC>(){

            public OptionalInt getMaxActiveSessions() {
                return OptionalInt.of(1);
            }

            public ByteBufferMarshaller getMarshaller() {
                return ProtoStreamTesterFactory.INSTANCE.getMarshaller();
            }

            public Supplier<SC> getSessionContextFactory() {
                return contextFactory;
            }

            public Immutability getImmutability() {
                return Immutability.getDefault();
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return InfinispanSessionManagerFactoryProvider.this.parameters.getSessionAttributePersistenceStrategy();
            }

            public String getDeploymentName() {
                return InfinispanSessionManagerFactoryProvider.DEPLOYMENT_NAME;
            }

            public String getServerName() {
                return InfinispanSessionManagerFactoryProvider.SERVER_NAME;
            }
        };
        InfinispanSessionManagerFactoryConfiguration<CacheContainerGroupMember> infinispan = new InfinispanSessionManagerFactoryConfiguration<CacheContainerGroupMember>((GroupCommandDispatcherFactory)commandDispatcherFactory){
            final /* synthetic */ GroupCommandDispatcherFactory val$commandDispatcherFactory;
            {
                this.val$commandDispatcherFactory = groupCommandDispatcherFactory;
            }

            public <K, V> Cache<K, V> getCache() {
                return InfinispanSessionManagerFactoryProvider.this.manager.getCache(InfinispanSessionManagerFactoryProvider.DEPLOYMENT_NAME);
            }

            public GroupCommandDispatcherFactory<org.infinispan.remoting.transport.Address, CacheContainerGroupMember> getCommandDispatcherFactory() {
                return this.val$commandDispatcherFactory;
            }
        };
        MockSessionSpecificationProvider provider = new MockSessionSpecificationProvider();
        return new InfinispanSessionManagerFactory(managerFactoryConfiguration, (SessionSpecificationProvider)provider, (SessionEventListenerSpecificationProvider)provider, (InfinispanSessionManagerFactoryConfiguration)infinispan);
    }

    public void close() throws Exception {
        this.manager.getCache(DEPLOYMENT_NAME).clear();
        this.manager.close();
        this.dispatcherFactoryProvider.close();
    }
}

