/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.time.Duration;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.context.ContextFactory;
import org.wildfly.clustering.server.context.ContextStrategy;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.infinispan.affinity.UnaryGroupMemberAffinity;
import org.wildfly.clustering.server.infinispan.expiration.ScheduleWithExpirationMetaDataCommandFactory;
import org.wildfly.clustering.server.infinispan.manager.AffinityIdentifierFactory;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerConfiguration;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleLocalKeysTask;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.server.infinispan.util.CacheInvoker;
import org.wildfly.clustering.server.manager.IdentifierFactory;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.server.util.Invoker;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.CompositeSessionFactory;
import org.wildfly.clustering.session.cache.ContextualSessionManager;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.attributes.IdentityMarshallerSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.MarshalledValueMarshallerSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.coarse.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.ImmutableSessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.session.infinispan.embedded.ExpiredSessionRemover;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManager;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.SessionAttributeActivationNotifierFactory;
import org.wildfly.clustering.session.infinispan.embedded.SessionExpirationScheduler;
import org.wildfly.clustering.session.infinispan.embedded.attributes.CoarseSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.embedded.attributes.FineSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.embedded.metadata.InfinispanSessionMetaDataFactory;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKeyFilter;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class InfinispanSessionManagerFactory<C, SC>
implements SessionManagerFactory<C, SC, TransactionBatch>,
Runnable {
    private final Scheduler<String, ExpirationMetaData> scheduler;
    private final SessionFactory<C, ContextualSessionMetaDataEntry<SC>, ?, SC> factory;
    private final BiConsumer<Locality, Locality> scheduleTask;
    private final ListenerRegistration schedulerListenerRegistration;
    private final EmbeddedCacheConfiguration configuration;
    private final Function<SessionManagerConfiguration<C>, Registrar<SessionManager<SC, TransactionBatch>>> managerRegistrarFactory;

    public <S, L, GM extends GroupMember<Address>> InfinispanSessionManagerFactory(SessionManagerFactoryConfiguration<SC> configuration, SessionSpecificationProvider<S, C> sessionProvider, SessionEventListenerSpecificationProvider<S, L> listenerProvider, InfinispanSessionManagerFactoryConfiguration<GM> infinispan) {
        this.configuration = infinispan;
        final SessionAttributeActivationNotifierFactory notifierFactory = new SessionAttributeActivationNotifierFactory(sessionProvider, listenerProvider);
        CacheProperties properties = infinispan.getCacheProperties();
        InfinispanSessionMetaDataFactory metaDataFactory = new InfinispanSessionMetaDataFactory(infinispan);
        this.factory = new CompositeSessionFactory(metaDataFactory, this.createSessionAttributesFactory(configuration, sessionProvider, listenerProvider, notifierFactory, infinispan), properties, configuration.getSessionContextFactory());
        final ExpiredSessionRemover remover = new ExpiredSessionRemover(this.factory);
        this.managerRegistrarFactory = new Function<SessionManagerConfiguration<C>, Registrar<SessionManager<SC, TransactionBatch>>>(){

            @Override
            public Registrar<SessionManager<SC, TransactionBatch>> apply(final SessionManagerConfiguration<C> managerConfiguration) {
                return new Registrar<SessionManager<SC, TransactionBatch>>(){

                    public Registration register(SessionManager<SC, TransactionBatch> manager) {
                        Registration contextRegistration = notifierFactory.register(Map.entry(managerConfiguration.getContext(), manager));
                        Registration expirationRegistration = remover.register(managerConfiguration.getExpirationListener());
                        return () -> {
                            expirationRegistration.close();
                            contextRegistration.close();
                        };
                    }
                };
            }
        };
        final Cache cache = infinispan.getCache();
        PrimaryOwnerScheduler localScheduler = new SessionExpirationScheduler((Batcher<TransactionBatch>)infinispan.getBatcher(), this.factory.getMetaDataFactory(), remover, Duration.ofMillis(cache.getCacheConfiguration().transaction().cacheStopTimeout()));
        final GroupCommandDispatcherFactory<Address, GM> dispatcherFactory = infinispan.getCommandDispatcherFactory();
        Group group = dispatcherFactory.getGroup();
        this.scheduler = group.isSingleton() ? localScheduler : new PrimaryOwnerScheduler(new PrimaryOwnerSchedulerConfiguration<String, ExpirationMetaData, GM>(){
            final /* synthetic */ CacheEntryScheduler val$localScheduler;
            final /* synthetic */ Group val$group;
            final /* synthetic */ CacheProperties val$properties;
            {
                this.val$localScheduler = cacheEntryScheduler;
                this.val$group = group;
                this.val$properties = cacheProperties;
            }

            public String getName() {
                return cache.getName();
            }

            public CommandDispatcherFactory<GM> getCommandDispatcherFactory() {
                return dispatcherFactory;
            }

            public CacheEntryScheduler<String, ExpirationMetaData> getScheduler() {
                return this.val$localScheduler;
            }

            public Function<String, GM> getAffinity() {
                return new UnaryGroupMemberAffinity(cache, this.val$group);
            }

            public BiFunction<String, ExpirationMetaData, ScheduleCommand<String, ExpirationMetaData>> getScheduleCommandFactory() {
                return this.val$properties.isTransactional() ? new ScheduleWithExpirationMetaDataCommandFactory() : ScheduleWithTransientMetaDataCommand::new;
            }

            public Invoker getInvoker() {
                return CacheInvoker.retrying((Cache)cache);
            }
        });
        this.scheduleTask = new ScheduleLocalKeysTask(cache, (Predicate)((Object)SessionMetaDataKeyFilter.INSTANCE), (CacheEntryScheduler)localScheduler);
        this.schedulerListenerRegistration = new SchedulerTopologyChangeListener(cache, (CacheEntryScheduler)localScheduler, this.scheduleTask).register();
    }

    @Override
    public void run() {
        this.scheduleTask.accept(Locality.of((boolean)false), Locality.forCurrentConsistentHash((Cache)this.configuration.getCache()));
    }

    public SessionManager<SC, TransactionBatch> createSessionManager(SessionManagerConfiguration<C> configuration) {
        AffinityIdentifierFactory identifierFactory = new AffinityIdentifierFactory(configuration.getIdentifierFactory(), this.configuration.getCache());
        final Registrar<SessionManager<SC, TransactionBatch>> registrar = this.managerRegistrarFactory.apply(configuration);
        InfinispanSessionManagerConfiguration infinispanConfiguration = new InfinispanSessionManagerConfiguration<SC>((IdentifierFactory)identifierFactory){
            final /* synthetic */ IdentifierFactory val$identifierFactory;
            {
                this.val$identifierFactory = identifierFactory;
            }

            @Override
            public Scheduler<String, ExpirationMetaData> getExpirationScheduler() {
                return InfinispanSessionManagerFactory.this.scheduler;
            }

            @Override
            public Runnable getStartTask() {
                return InfinispanSessionManagerFactory.this;
            }

            @Override
            public Registrar<SessionManager<SC, TransactionBatch>> getRegistrar() {
                return registrar;
            }

            public <K, V> Cache<K, V> getCache() {
                return InfinispanSessionManagerFactory.this.configuration.getCache();
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }
        };
        return new ContextualSessionManager(new InfinispanSessionManager(configuration, infinispanConfiguration, this.factory), (ContextFactory)(this.configuration.getCacheProperties().isTransactional() ? ContextStrategy.UNSHARED : ContextStrategy.SHARED));
    }

    private <S, L, GM extends GroupMember<Address>> SessionAttributesFactory<C, ?> createSessionAttributesFactory(SessionManagerFactoryConfiguration<SC> configuration, SessionSpecificationProvider<S, C> sessionProvider, SessionEventListenerSpecificationProvider<S, L> listenerProvider, Function<String, SessionAttributeActivationNotifier> detachedPassivationNotifierFactory, EmbeddedCacheConfiguration infinispan) {
        boolean marshalling = infinispan.getCacheProperties().isMarshalling();
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                BiFunction<ImmutableSession, Object, SessionAttributeActivationNotifier> passivationNotifierFactory = (session, context) -> new ImmutableSessionAttributeActivationNotifier(sessionProvider, listenerProvider, session, context);
                return marshalling ? new FineSessionAttributesFactory(new MarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration), passivationNotifierFactory, detachedPassivationNotifierFactory, infinispan) : new FineSessionAttributesFactory(new IdentityMarshallerSessionAttributesFactoryConfiguration(configuration), passivationNotifierFactory, detachedPassivationNotifierFactory, infinispan);
            }
            case COARSE: {
                BiFunction<ImmutableSession, Object, SessionActivationNotifier> passivationNotifierFactory = (session, context) -> new ImmutableSessionActivationNotifier(sessionProvider, listenerProvider, session, context);
                return marshalling ? new CoarseSessionAttributesFactory(new MarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration), passivationNotifierFactory, detachedPassivationNotifierFactory, infinispan) : new CoarseSessionAttributesFactory(new IdentityMarshallerSessionAttributesFactoryConfiguration(configuration), passivationNotifierFactory, detachedPassivationNotifierFactory, infinispan);
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        this.schedulerListenerRegistration.close();
        this.scheduler.close();
        this.factory.close();
    }
}

