/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.context.Flag;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.manager.IdentifierFactory;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.AbstractSessionManager;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKeyFilter;

public class InfinispanSessionManager<DC, MV, AV, SC>
extends AbstractSessionManager<DC, MV, AV, SC, TransactionBatch> {
    private final Batcher<TransactionBatch> batcher;
    private final Cache<Key<String>, ?> cache;
    private final CacheProperties properties;
    private final IdentifierFactory<String> identifierFactory;
    private final Scheduler<String, ExpirationMetaData> expirationScheduler;
    private final Runnable startTask;
    private final Registrar<SessionManager<SC, TransactionBatch>> registrar;
    private volatile Registration registration;

    public InfinispanSessionManager(final InfinispanSessionManagerConfiguration<DC, SC> configuration, SessionFactory<DC, MV, AV, SC> factory) {
        super(configuration, configuration, factory, (Consumer)new Consumer<ImmutableSession>(){

            @Override
            public void accept(ImmutableSession session) {
                if (session.isValid()) {
                    configuration.getExpirationScheduler().schedule((Object)session.getId(), (Object)session.getMetaData());
                }
            }
        });
        this.cache = configuration.getCache();
        this.properties = configuration.getCacheProperties();
        this.identifierFactory = configuration.getIdentifierFactory();
        this.batcher = configuration.getBatcher();
        this.expirationScheduler = configuration.getExpirationScheduler();
        this.registrar = configuration.getRegistrar();
        this.startTask = configuration.getStartTask();
    }

    public void start() {
        this.registration = this.registrar.register((Object)this);
        this.identifierFactory.start();
        this.startTask.run();
    }

    public void stop() {
        PersistenceConfiguration persistence;
        if (!this.properties.isPersistent() && (persistence = this.cache.getCacheConfiguration().persistence()).passivation() && !persistence.stores().stream().allMatch(StoreConfiguration::purgeOnStartup)) {
            try (CacheStream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_LOCKING}).keySet().stream();){
                stream.filter(SessionMetaDataKeyFilter.INSTANCE).forEach(arg_0 -> this.cache.evict(arg_0));
            }
        }
        this.identifierFactory.stop();
        this.registration.close();
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public CompletionStage<Session<SC>> findSessionAsync(String id) {
        this.expirationScheduler.cancel((Object)id);
        return super.findSessionAsync(id);
    }

    public SessionStatistics getStatistics() {
        return this;
    }

    public Set<String> getActiveSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD);
    }

    public Set<String> getSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL);
    }

    private Set<String> getSessions(Flag ... flags) {
        Locality locality = Locality.forCurrentConsistentHash(this.cache);
        try (CacheStream keys = this.cache.getAdvancedCache().withFlags(flags).keySet().stream();){
            Set<String> set = keys.filter(SessionMetaDataKeyFilter.INSTANCE.and(key -> locality.isLocal(key))).map(key -> (String)key.getId()).collect(Collectors.toSet());
            return set;
        }
    }
}

