/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.OOBSession;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.container.SessionActivationListenerFacadeProvider;

public class SessionAttributeActivationNotifierFactory<S, SC, AL, LC, B extends Batch>
implements Function<String, SessionAttributeActivationNotifier>,
Registrar<Map.Entry<SC, SessionManager<LC, B>>> {
    private final Map<SC, SessionManager<LC, B>> contexts = new ConcurrentHashMap<SC, SessionManager<LC, B>>();
    private final SessionActivationListenerFacadeProvider<S, SC, AL> provider;
    private final Function<AL, Consumer<S>> prePassivateNotifier;
    private final Function<AL, Consumer<S>> postActivateNotifier;

    public SessionAttributeActivationNotifierFactory(SessionActivationListenerFacadeProvider<S, SC, AL> provider) {
        this.provider = provider;
        this.prePassivateNotifier = arg_0 -> provider.prePassivateNotifier(arg_0);
        this.postActivateNotifier = arg_0 -> provider.postActivateNotifier(arg_0);
    }

    public Registration register(Map.Entry<SC, SessionManager<LC, B>> entry) {
        SC context = entry.getKey();
        this.contexts.put(context, entry.getValue());
        return () -> this.contexts.remove(context);
    }

    @Override
    public SessionAttributeActivationNotifier apply(final String sessionId) {
        final Map<SC, SessionManager<LC, B>> contexts = this.contexts;
        final SessionActivationListenerFacadeProvider<S, SC, AL> provider = this.provider;
        final Function<AL, Consumer<S>> prePassivateNotifier = this.prePassivateNotifier;
        final Function<AL, Consumer<S>> postActivateNotifier = this.postActivateNotifier;
        return new SessionAttributeActivationNotifier(){

            public void prePassivate(Object value) {
                this.notify(prePassivateNotifier, value);
            }

            public void postActivate(Object value) {
                this.notify(postActivateNotifier, value);
            }

            public void notify(Function<AL, Consumer<S>> notifier, Object value) {
                Optional listener = provider.asSessionActivationListener(value);
                if (listener.isPresent()) {
                    for (Map.Entry entry : contexts.entrySet()) {
                        Object context = entry.getKey();
                        SessionManager manager = (SessionManager)entry.getValue();
                        OOBSession session = new OOBSession(manager, sessionId, null);
                        notifier.apply(listener.get()).accept(provider.asSession((ImmutableSession)session, context));
                    }
                }
            }

            public void close() {
            }
        };
    }
}

