/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionAttributes;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.SessionFactory;

public class ExpiredSessionRemover<SC, MV, AV, LC>
implements Predicate<String>,
Registrar<Consumer<ImmutableSession>> {
    private static final Logger LOGGER = Logger.getLogger(ExpiredSessionRemover.class);
    private final SessionFactory<SC, MV, AV, LC> factory;
    private final Collection<Consumer<ImmutableSession>> listeners = new CopyOnWriteArraySet<Consumer<ImmutableSession>>();

    public ExpiredSessionRemover(SessionFactory<SC, MV, AV, LC> factory) {
        this.factory = factory;
    }

    @Override
    public boolean test(String id) {
        Object metaDataValue = this.factory.getMetaDataFactory().tryValue((Object)id);
        if (metaDataValue != null) {
            ImmutableSessionMetaData metaData = this.factory.getMetaDataFactory().createImmutableSessionMetaData(id, metaDataValue);
            if (metaData.isExpired()) {
                Object attributesValue = this.factory.getAttributesFactory().findValue((Object)id);
                if (attributesValue != null) {
                    ImmutableSessionAttributes attributes = this.factory.getAttributesFactory().createImmutableSessionAttributes(id, attributesValue);
                    ImmutableSession session = this.factory.createImmutableSession(id, metaData, attributes);
                    LOGGER.tracef("Session %s has expired.", (Object)id);
                    for (Consumer<ImmutableSession> listener : this.listeners) {
                        listener.accept(session);
                    }
                }
                try {
                    this.factory.remove((Object)id);
                    return true;
                }
                catch (CancellationException e) {
                    return false;
                }
            }
            LOGGER.tracef("Session %s is not yet expired.", (Object)id);
        } else {
            LOGGER.tracef("Session %s was not found or is currently in use.", (Object)id);
        }
        return false;
    }

    public Registration register(Consumer<ImmutableSession> listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }
}

