/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.UUID;
import java.util.function.Consumer;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionAttributes;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.session.infinispan.embedded.ExpiredSessionRemover;

public class ExpiredSessionRemoverTestCase {
    @Test
    public void test() {
        SessionFactory factory = (SessionFactory)Mockito.mock(SessionFactory.class);
        SessionMetaDataFactory metaDataFactory = (SessionMetaDataFactory)Mockito.mock(SessionMetaDataFactory.class);
        SessionAttributesFactory attributesFactory = (SessionAttributesFactory)Mockito.mock(SessionAttributesFactory.class);
        Consumer listener = (Consumer)Mockito.mock(Consumer.class);
        ImmutableSessionAttributes expiredAttributes = (ImmutableSessionAttributes)Mockito.mock(ImmutableSessionAttributes.class);
        ImmutableSessionMetaData validMetaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ImmutableSessionMetaData expiredMetaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ImmutableSession expiredSession = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        String missingSessionId = "missing";
        String expiredSessionId = "expired";
        String validSessionId = "valid";
        UUID expiredMetaDataValue = UUID.randomUUID();
        UUID expiredAttributesValue = UUID.randomUUID();
        UUID validMetaDataValue = UUID.randomUUID();
        ExpiredSessionRemover subject = new ExpiredSessionRemover(factory);
        try (Registration regisration = subject.register(listener);){
            Mockito.when((Object)factory.getMetaDataFactory()).thenReturn((Object)metaDataFactory);
            Mockito.when((Object)factory.getAttributesFactory()).thenReturn((Object)attributesFactory);
            Mockito.when((Object)((UUID)metaDataFactory.tryValue((Object)missingSessionId))).thenReturn(null);
            Mockito.when((Object)((UUID)metaDataFactory.tryValue((Object)expiredSessionId))).thenReturn((Object)expiredMetaDataValue);
            Mockito.when((Object)((UUID)metaDataFactory.tryValue((Object)validSessionId))).thenReturn((Object)validMetaDataValue);
            Mockito.when((Object)metaDataFactory.createImmutableSessionMetaData(expiredSessionId, (Object)expiredMetaDataValue)).thenReturn((Object)expiredMetaData);
            Mockito.when((Object)metaDataFactory.createImmutableSessionMetaData(validSessionId, (Object)validMetaDataValue)).thenReturn((Object)validMetaData);
            Mockito.when((Object)expiredMetaData.isExpired()).thenReturn((Object)true);
            Mockito.when((Object)validMetaData.isExpired()).thenReturn((Object)false);
            Mockito.when((Object)((UUID)attributesFactory.findValue((Object)expiredSessionId))).thenReturn((Object)expiredAttributesValue);
            Mockito.when((Object)attributesFactory.createImmutableSessionAttributes(expiredSessionId, (Object)expiredAttributesValue)).thenReturn((Object)expiredAttributes);
            Mockito.when((Object)factory.createImmutableSession((String)ArgumentMatchers.same((Object)expiredSessionId), (ImmutableSessionMetaData)ArgumentMatchers.same((Object)expiredMetaData), (ImmutableSessionAttributes)ArgumentMatchers.same((Object)expiredAttributes))).thenReturn((Object)expiredSession);
            subject.test(missingSessionId);
            subject.test(expiredSessionId);
            subject.test(validSessionId);
            ((SessionFactory)Mockito.verify((Object)factory)).remove((Object)expiredSessionId);
            ((SessionFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.never())).remove((Object)missingSessionId);
            ((SessionFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.never())).remove((Object)validSessionId);
            ((Consumer)Mockito.verify((Object)listener)).accept(expiredSession);
        }
    }
}

