/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.time.Duration;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.context.ContextFactory;
import org.wildfly.clustering.server.context.ContextStrategy;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.expiration.ExpirationMetaData;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.infinispan.affinity.UnaryGroupMemberAffinity;
import org.wildfly.clustering.server.infinispan.expiration.ScheduleWithExpirationMetaDataCommandFactory;
import org.wildfly.clustering.server.infinispan.manager.AffinityIdentifierFactory;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerConfiguration;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleLocalKeysTask;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.server.infinispan.util.CacheInvoker;
import org.wildfly.clustering.server.manager.IdentifierFactory;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.server.util.Invoker;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.CompositeSessionFactory;
import org.wildfly.clustering.session.cache.ContextualSessionManager;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.attributes.IdentityMarshallerSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.MarshalledValueMarshallerSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.session.container.ContainerFacadeProvider;
import org.wildfly.clustering.session.infinispan.embedded.ExpiredSessionRemover;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManager;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.SessionAttributeActivationNotifierFactory;
import org.wildfly.clustering.session.infinispan.embedded.SessionExpirationScheduler;
import org.wildfly.clustering.session.infinispan.embedded.attributes.CoarseSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.embedded.attributes.FineSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.embedded.attributes.InfinispanSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.metadata.InfinispanSessionMetaDataFactory;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKeyFilter;

public class InfinispanSessionManagerFactory<S, SC, AL, LC>
implements SessionManagerFactory<SC, LC, TransactionBatch>,
Runnable {
    private final Scheduler<String, ExpirationMetaData> scheduler;
    private final ContainerFacadeProvider<S, SC, AL> provider;
    private final SessionFactory<SC, ContextualSessionMetaDataEntry<LC>, ?, LC> factory;
    private final BiConsumer<Locality, Locality> scheduleTask;
    private final ListenerRegistration schedulerListenerRegistration;
    private final EmbeddedCacheConfiguration configuration;
    private final ExpiredSessionRemover<SC, ?, ?, LC> remover;
    private final SessionAttributeActivationNotifierFactory<S, SC, AL, LC, TransactionBatch> notifierFactory;

    public <GM extends GroupMember<Address>> InfinispanSessionManagerFactory(SessionManagerFactoryConfiguration<S, SC, AL, LC> configuration, InfinispanSessionManagerFactoryConfiguration<GM> infinispan) {
        this.configuration = infinispan;
        this.provider = configuration.getContainerFacadeProvider();
        this.notifierFactory = new SessionAttributeActivationNotifierFactory(this.provider);
        CacheProperties properties = infinispan.getCacheProperties();
        InfinispanSessionMetaDataFactory metaDataFactory = new InfinispanSessionMetaDataFactory(infinispan);
        this.factory = new CompositeSessionFactory(metaDataFactory, this.createSessionAttributesFactory(configuration, infinispan), configuration.getSessionContextFactory());
        this.remover = new ExpiredSessionRemover(this.factory);
        final Cache cache = infinispan.getCache();
        PrimaryOwnerScheduler localScheduler = new SessionExpirationScheduler((Batcher<TransactionBatch>)infinispan.getBatcher(), this.factory.getMetaDataFactory(), this.remover, Duration.ofMillis(cache.getCacheConfiguration().transaction().cacheStopTimeout()));
        final GroupCommandDispatcherFactory<Address, GM> dispatcherFactory = infinispan.getCommandDispatcherFactory();
        Group group = dispatcherFactory.getGroup();
        this.scheduler = group.isSingleton() ? localScheduler : new PrimaryOwnerScheduler(new PrimaryOwnerSchedulerConfiguration<String, ExpirationMetaData, GM>(){
            final /* synthetic */ CacheEntryScheduler val$localScheduler;
            final /* synthetic */ Group val$group;
            final /* synthetic */ CacheProperties val$properties;
            {
                this.val$localScheduler = cacheEntryScheduler;
                this.val$group = group;
                this.val$properties = cacheProperties;
            }

            public String getName() {
                return cache.getName();
            }

            public CommandDispatcherFactory<GM> getCommandDispatcherFactory() {
                return dispatcherFactory;
            }

            public CacheEntryScheduler<String, ExpirationMetaData> getScheduler() {
                return this.val$localScheduler;
            }

            public Function<String, GM> getAffinity() {
                return new UnaryGroupMemberAffinity(cache, this.val$group);
            }

            public BiFunction<String, ExpirationMetaData, ScheduleCommand<String, ExpirationMetaData>> getScheduleCommandFactory() {
                return this.val$properties.isTransactional() ? new ScheduleWithExpirationMetaDataCommandFactory() : ScheduleWithTransientMetaDataCommand::new;
            }

            public Invoker getInvoker() {
                return CacheInvoker.retrying((Cache)cache);
            }
        });
        this.scheduleTask = new ScheduleLocalKeysTask(cache, (Predicate)((Object)SessionMetaDataKeyFilter.INSTANCE), (CacheEntryScheduler)localScheduler);
        this.schedulerListenerRegistration = new SchedulerTopologyChangeListener(cache, (CacheEntryScheduler)localScheduler, this.scheduleTask).register();
    }

    @Override
    public void run() {
        this.scheduleTask.accept(Locality.of((boolean)false), Locality.forCurrentConsistentHash((Cache)this.configuration.getCache()));
    }

    public SessionManager<LC, TransactionBatch> createSessionManager(SessionManagerConfiguration<SC> configuration) {
        AffinityIdentifierFactory identifierFactory = new AffinityIdentifierFactory(configuration.getIdentifierFactory(), this.configuration.getCache());
        final Registrar registrar = manager -> {
            Registration contextRegistration = this.notifierFactory.register(Map.entry(configuration.getContext(), manager));
            Registration expirationRegistration = this.remover.register(configuration.getExpirationListener());
            return () -> {
                expirationRegistration.close();
                contextRegistration.close();
            };
        };
        InfinispanSessionManagerConfiguration infinispanConfiguration = new InfinispanSessionManagerConfiguration<LC>((IdentifierFactory)identifierFactory){
            final /* synthetic */ IdentifierFactory val$identifierFactory;
            {
                this.val$identifierFactory = identifierFactory;
            }

            @Override
            public Scheduler<String, ExpirationMetaData> getExpirationScheduler() {
                return InfinispanSessionManagerFactory.this.scheduler;
            }

            @Override
            public Runnable getStartTask() {
                return InfinispanSessionManagerFactory.this;
            }

            @Override
            public Registrar<SessionManager<LC, TransactionBatch>> getRegistrar() {
                return registrar;
            }

            public <K, V> Cache<K, V> getCache() {
                return InfinispanSessionManagerFactory.this.configuration.getCache();
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }
        };
        return new ContextualSessionManager(new InfinispanSessionManager(configuration, infinispanConfiguration, this.factory), (ContextFactory)(this.configuration.getCacheProperties().isTransactional() ? ContextStrategy.UNSHARED : ContextStrategy.SHARED));
    }

    private <GM extends GroupMember<Address>> SessionAttributesFactory<SC, ?> createSessionAttributesFactory(SessionManagerFactoryConfiguration<S, SC, AL, LC> configuration, InfinispanSessionManagerFactoryConfiguration<GM> infinispan) {
        boolean marshalling = infinispan.getCacheProperties().isMarshalling();
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                return marshalling ? new FineSessionAttributesFactory(new InfinispanMarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration, this.notifierFactory), infinispan) : new FineSessionAttributesFactory(new InfinispanIdentityMarshallerSessionAttributesFactoryConfiguration(configuration, this.notifierFactory), infinispan);
            }
            case COARSE: {
                return marshalling ? new CoarseSessionAttributesFactory(new InfinispanMarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration, this.notifierFactory), infinispan) : new CoarseSessionAttributesFactory(new InfinispanIdentityMarshallerSessionAttributesFactoryConfiguration(configuration, this.notifierFactory), infinispan);
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        this.schedulerListenerRegistration.close();
        this.scheduler.close();
        this.factory.close();
    }

    private static class InfinispanMarshalledValueMarshallerSessionAttributesFactoryConfiguration<S, SC, AL, V>
    extends MarshalledValueMarshallerSessionAttributesFactoryConfiguration<S, SC, AL, V>
    implements InfinispanSessionAttributesFactoryConfiguration<S, SC, AL, V, MarshalledValue<V, ByteBufferMarshaller>> {
        private final Function<String, SessionAttributeActivationNotifier> notifierFactory;

        <LC> InfinispanMarshalledValueMarshallerSessionAttributesFactoryConfiguration(SessionManagerFactoryConfiguration<S, SC, AL, LC> configuration, Function<String, SessionAttributeActivationNotifier> notifierFactory) {
            super(configuration);
            this.notifierFactory = notifierFactory;
        }

        @Override
        public Function<String, SessionAttributeActivationNotifier> getActivationNotifierFactory() {
            return this.notifierFactory;
        }
    }

    private static class InfinispanIdentityMarshallerSessionAttributesFactoryConfiguration<S, SC, AL, V>
    extends IdentityMarshallerSessionAttributesFactoryConfiguration<S, SC, AL, V>
    implements InfinispanSessionAttributesFactoryConfiguration<S, SC, AL, V, V> {
        private final Function<String, SessionAttributeActivationNotifier> notifierFactory;

        <LC> InfinispanIdentityMarshallerSessionAttributesFactoryConfiguration(SessionManagerFactoryConfiguration<S, SC, AL, LC> configuration, Function<String, SessionAttributeActivationNotifier> notifierFactory) {
            super(configuration);
            this.notifierFactory = notifierFactory;
        }

        @Override
        public Function<String, SessionAttributeActivationNotifier> getActivationNotifierFactory() {
            return this.notifierFactory;
        }
    }
}

