/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded.attributes;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheComputeMutatorFactory;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.cache.infinispan.embedded.listener.PostActivateBlockingListener;
import org.wildfly.clustering.cache.infinispan.embedded.listener.PostPassivateBlockingListener;
import org.wildfly.clustering.cache.infinispan.embedded.listener.PrePassivateBlockingListener;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.CompositeImmutableSession;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.fine.FineSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeMapComputeFunction;
import org.wildfly.clustering.session.infinispan.embedded.attributes.SessionAttributesKey;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKey;
import org.wildfly.common.function.Functions;

public class FineSessionAttributesFactory<C, V>
implements SessionAttributesFactory<C, Map<String, Object>> {
    private static final Logger LOGGER = Logger.getLogger(FineSessionAttributesFactory.class);
    private final Cache<SessionAttributesKey, Map<String, V>> cache;
    private final Cache<SessionAttributesKey, Map<String, V>> writeCache;
    private final Cache<SessionAttributesKey, Map<String, V>> silentCache;
    private final Marshaller<Object, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final CacheEntryMutatorFactory<SessionAttributesKey, Map<String, V>> mutatorFactory;
    private final BiFunction<ImmutableSession, C, SessionAttributeActivationNotifier> notifierFactory;
    private final Function<String, SessionAttributeActivationNotifier> detachedNotifierFactory;
    private final ListenerRegistration evictListenerRegistration;
    private final ListenerRegistration prePassivateListenerRegistration;
    private final ListenerRegistration postActivateListenerRegistration;

    public FineSessionAttributesFactory(SessionAttributesFactoryConfiguration<Object, V> configuration, BiFunction<ImmutableSession, C, SessionAttributeActivationNotifier> notifierFactory, Function<String, SessionAttributeActivationNotifier> detachedNotifierFactory, EmbeddedCacheConfiguration infinispan) {
        this.cache = infinispan.getCache();
        this.writeCache = infinispan.getWriteOnlyCache();
        this.silentCache = infinispan.getSilentWriteCache();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = infinispan.getCacheProperties();
        this.mutatorFactory = new EmbeddedCacheComputeMutatorFactory(this.cache, SessionAttributeMapComputeFunction::new);
        this.notifierFactory = notifierFactory;
        this.detachedNotifierFactory = detachedNotifierFactory;
        this.prePassivateListenerRegistration = !this.properties.isPersistent() ? new PrePassivateBlockingListener(this.cache, this::prePassivate).register(SessionAttributesKey.class) : null;
        this.postActivateListenerRegistration = !this.properties.isPersistent() ? new PostActivateBlockingListener(this.cache, this::postActivate).register(SessionAttributesKey.class) : null;
        this.evictListenerRegistration = new PostPassivateBlockingListener(infinispan.getCache(), this::cascadeEvict).register(SessionMetaDataKey.class);
    }

    public void close() {
        this.evictListenerRegistration.close();
        if (this.prePassivateListenerRegistration != null) {
            this.prePassivateListenerRegistration.close();
        }
        if (this.postActivateListenerRegistration != null) {
            this.postActivateListenerRegistration.close();
        }
    }

    public CompletionStage<Map<String, Object>> createValueAsync(String id, Void context) {
        return CompletableFuture.completedStage(this.createValue(id, context));
    }

    public Map<String, Object> createValue(String id, Void context) {
        return new ConcurrentHashMap<String, Object>();
    }

    public CompletionStage<Map<String, Object>> findValueAsync(String id) {
        return this.getValueAsync(id).exceptionally(e -> {
            LOGGER.warn((Object)e.getLocalizedMessage(), e);
            this.removeAsync(id);
            return null;
        });
    }

    public CompletionStage<Map<String, Object>> tryValueAsync(String id) {
        return this.getValueAsync(id).exceptionally(e -> null);
    }

    private CompletionStage<Map<String, Object>> getValueAsync(String id) {
        return this.cache.getAsync((Object)new SessionAttributesKey(id)).thenApply(value -> {
            Map<String, Object> attributes = this.createValue(id, null);
            if (value != null) {
                for (Map.Entry entry : value.entrySet()) {
                    String attributeName = (String)entry.getKey();
                    try {
                        attributes.put(attributeName, this.marshaller.read(entry.getValue()));
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(attributeName, e);
                    }
                }
            }
            return attributes;
        });
    }

    public CompletionStage<Void> removeAsync(String id) {
        return this.deleteAsync(this.writeCache, id);
    }

    public CompletionStage<Void> purgeAsync(String id) {
        return this.deleteAsync(this.silentCache, id);
    }

    private CompletionStage<Void> deleteAsync(Cache<SessionAttributesKey, Map<String, V>> cache, String id) {
        return cache.removeAsync((Object)new SessionAttributesKey(id)).thenAccept(Functions.discardingConsumer());
    }

    public Map<String, Object> createImmutableSessionAttributes(String id, Map<String, Object> attributes) {
        return Map.copyOf(attributes);
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, Object> attributes, ImmutableSessionMetaData metaData, C context) {
        SessionAttributeActivationNotifier notifier = this.properties.isPersistent() ? this.notifierFactory.apply((ImmutableSession)new CompositeImmutableSession(id, metaData, this.createImmutableSessionAttributes(id, attributes)), context) : null;
        return new FineSessionAttributes((Object)new SessionAttributesKey(id), attributes, this.mutatorFactory, this.marshaller, this.immutability, this.properties, notifier);
    }

    private void cascadeEvict(SessionMetaDataKey key) {
        this.cache.evict((Object)new SessionAttributesKey((String)key.getId()));
    }

    private void prePassivate(SessionAttributesKey key, Map<String, V> attributes) {
        this.notify(SessionAttributeActivationNotifier.PRE_PASSIVATE, key, attributes);
    }

    private void postActivate(SessionAttributesKey key, Map<String, V> attributes) {
        this.notify(SessionAttributeActivationNotifier.POST_ACTIVATE, key, attributes);
    }

    private void notify(BiConsumer<SessionAttributeActivationNotifier, Object> notification, SessionAttributesKey key, Map<String, V> attributes) {
        String id = (String)key.getId();
        for (Map.Entry<String, V> entry : attributes.entrySet()) {
            try {
                SessionAttributeActivationNotifier notifier = this.detachedNotifierFactory.apply(id);
                try {
                    notification.accept(notifier, this.marshaller.read(entry.getValue()));
                }
                finally {
                    if (notifier == null) continue;
                    notifier.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)entry.getKey(), (Throwable)e);
            }
        }
    }
}

