/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.server.infinispan.expiration.AbstractExpirationScheduler;
import org.wildfly.clustering.server.local.scheduler.LocalScheduler;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerConfiguration;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.ImmutableSessionMetaDataFactory;

public class SessionExpirationScheduler<MV>
extends AbstractExpirationScheduler<String> {
    private static final Logger LOGGER = Logger.getLogger(SessionExpirationScheduler.class);
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(SessionExpirationScheduler.class);
    private final ImmutableSessionMetaDataFactory<MV> metaDataFactory;

    public SessionExpirationScheduler(final Batcher<TransactionBatch> batcher, ImmutableSessionMetaDataFactory<MV> metaDataFactory, final Predicate<String> remover, final Duration closeTimeout) {
        this(new LocalSchedulerConfiguration<String>(){

            public Predicate<String> getTask() {
                return new SessionRemoveTask((Batcher<TransactionBatch>)batcher, remover);
            }

            public Duration getCloseTimeout() {
                return closeTimeout;
            }

            public ThreadFactory getThreadFactory() {
                return THREAD_FACTORY;
            }
        }, metaDataFactory);
    }

    public SessionExpirationScheduler(LocalSchedulerConfiguration<String> config, ImmutableSessionMetaDataFactory<MV> metaDataFactory) {
        this((Scheduler<String, Instant>)new LocalScheduler(config), metaDataFactory);
    }

    public SessionExpirationScheduler(Scheduler<String, Instant> scheduler, ImmutableSessionMetaDataFactory<MV> metaDataFactory) {
        super(scheduler);
        this.metaDataFactory = metaDataFactory;
    }

    public void schedule(String id) {
        Object value = this.metaDataFactory.findValue((Object)id);
        if (value != null) {
            ImmutableSessionMetaData metaData = this.metaDataFactory.createImmutableSessionMetaData(id, value);
            this.schedule(id, metaData);
        }
    }

    private static class SessionRemoveTask
    implements Predicate<String> {
        private final Batcher<TransactionBatch> batcher;
        private final Predicate<String> remover;

        SessionRemoveTask(Batcher<TransactionBatch> batcher, Predicate<String> remover) {
            this.batcher = batcher;
            this.remover = remover;
        }

        @Override
        public boolean test(String id) {
            boolean bl;
            block10: {
                LOGGER.debugf("Expiring session %s", (Object)id);
                Batch batch = this.batcher.createBatch();
                try {
                    bl = this.remover.test(id);
                    if (batch == null) break block10;
                }
                catch (RuntimeException e) {
                    try {
                        try {
                            batch.discard();
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (batch != null) {
                                try {
                                    batch.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (RuntimeException e2) {
                        LOGGER.warnf((Throwable)e2, id.toString(), new Object[0]);
                        return false;
                    }
                }
                batch.close();
            }
            return bl;
        }
    }
}

