/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.EnumSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.transaction.TransactionMode;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.cache.SessionManagerITCase;
import org.wildfly.clustering.session.cache.SessionManagerParameters;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryProvider;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerParameters;

public class InfinispanSessionManagerITCase
extends SessionManagerITCase<InfinispanSessionManagerParameters> {
    InfinispanSessionManagerITCase() {
        super(InfinispanSessionManagerFactoryProvider::new);
    }

    @ParameterizedTest
    @ArgumentsSource(value=InfinispanSessionManagerArgumentsProvider.class)
    public void basic(InfinispanSessionManagerParameters parameters) throws Exception {
        super.basic((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=InfinispanSessionManagerArgumentsProvider.class)
    public void concurrent(InfinispanSessionManagerParameters parameters) throws Exception {
        super.concurrent((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=InfinispanSessionManagerArgumentsProvider.class)
    public void expiration(InfinispanSessionManagerParameters parameters) throws Exception {
        super.expiration((SessionManagerParameters)parameters);
    }

    static class InfinispanSessionManagerArgumentsProvider
    implements ArgumentsProvider {
        InfinispanSessionManagerArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            Stream.Builder<Arguments> builder = Stream.builder();
            for (MarshallingTesterFactory factory : ServiceLoader.load(MarshallingTesterFactory.class, MarshallingTesterFactory.class.getClassLoader())) {
                final ByteBufferMarshaller marshaller = factory.getMarshaller();
                for (final SessionAttributePersistenceStrategy strategy : EnumSet.allOf(SessionAttributePersistenceStrategy.class)) {
                    for (final CacheMode cacheMode : EnumSet.of(CacheMode.DIST_SYNC, CacheMode.REPL_SYNC)) {
                        for (final TransactionMode transactionMode : EnumSet.allOf(TransactionMode.class)) {
                            builder.add(Arguments.of((Object[])new Object[]{new InfinispanSessionManagerParameters(){
                                final /* synthetic */ InfinispanSessionManagerArgumentsProvider this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                public ByteBufferMarshaller getSessionAttributeMarshaller() {
                                    return marshaller;
                                }

                                public SessionAttributePersistenceStrategy getSessionAttributePersistenceStrategy() {
                                    return strategy;
                                }

                                @Override
                                public CacheMode getCacheMode() {
                                    return cacheMode;
                                }

                                @Override
                                public TransactionMode getTransactionMode() {
                                    return transactionMode;
                                }

                                public String toString() {
                                    return Map.of(ByteBufferMarshaller.class.getSimpleName(), marshaller.toString(), SessionAttributePersistenceStrategy.class.getSimpleName(), strategy, CacheMode.class.getSimpleName(), cacheMode, TransactionMode.class.getSimpleName(), transactionMode).toString();
                                }
                            }}));
                        }
                    }
                }
            }
            return builder.build();
        }
    }
}

