/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.jgroups.Address;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.server.AutoCloseableProvider;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.ForkChannelFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactoryProvider;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.MockSessionSpecificationProvider;
import org.wildfly.clustering.session.cache.SessionManagerFactoryProvider;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerParameters;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class InfinispanSessionManagerFactoryProvider<C>
extends AutoCloseableProvider
implements SessionManagerFactoryProvider<C> {
    private static final String CONTAINER_NAME = "container";
    private static final String SERVER_NAME = "server";
    private static final String DEPLOYMENT_NAME_PATTERN = "%s-%s-%s-%s.war";
    private final InfinispanSessionManagerParameters parameters;
    private final ChannelCommandDispatcherFactoryProvider dispatcherFactoryProvider;
    private final EmbeddedCacheManager manager;
    private final String deploymentName;

    public InfinispanSessionManagerFactoryProvider(InfinispanSessionManagerParameters parameters, String memberName) throws Exception {
        this.parameters = parameters;
        this.deploymentName = String.format(DEPLOYMENT_NAME_PATTERN, parameters.getSessionAttributeMarshaller(), parameters.getSessionAttributePersistenceStrategy().name(), parameters.getCacheMode().name(), parameters.getTransactionMode().name());
        this.dispatcherFactoryProvider = new ChannelCommandDispatcherFactoryProvider(parameters.getClusterName(), memberName);
        this.accept(() -> ((ChannelCommandDispatcherFactoryProvider)this.dispatcherFactoryProvider).close());
        this.manager = new EmbeddedCacheManagerFactory((Function)new ForkChannelFactory(this.dispatcherFactoryProvider.getChannel()), parameters.getClusterName(), memberName).apply(CONTAINER_NAME, InfinispanSessionManagerFactoryConfiguration.class.getClassLoader());
        this.manager.start();
        this.accept(() -> ((EmbeddedCacheManager)this.manager).stop());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(parameters.getCacheMode());
        builder.transaction().transactionMode(parameters.getTransactionMode());
        if (parameters.getTransactionMode().isTransactional()) {
            builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
            builder.transaction().transactionManagerLookup(EmbeddedTransactionManager::getInstance);
            builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        }
        this.manager.defineConfiguration(this.deploymentName, builder.build());
        this.accept(() -> this.manager.undefineConfiguration(this.deploymentName));
    }

    public <SC> SessionManagerFactory<C, SC> createSessionManagerFactory(final Supplier<SC> contextFactory) {
        EmbeddedCacheManagerCommandDispatcherFactory commandDispatcherFactory = new EmbeddedCacheManagerCommandDispatcherFactory((EmbeddedCacheManagerCommandDispatcherFactoryConfiguration)new ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){

            public EmbeddedCacheManager getCacheContainer() {
                return InfinispanSessionManagerFactoryProvider.this.manager;
            }

            public GroupCommandDispatcherFactory<Address, ChannelGroupMember> getCommandDispatcherFactory() {
                return InfinispanSessionManagerFactoryProvider.this.dispatcherFactoryProvider.getCommandDispatcherFactory();
            }
        });
        SessionManagerFactoryConfiguration managerFactoryConfiguration = new SessionManagerFactoryConfiguration<SC>(){

            public OptionalInt getMaxActiveSessions() {
                return OptionalInt.of(1);
            }

            public ByteBufferMarshaller getMarshaller() {
                return InfinispanSessionManagerFactoryProvider.this.parameters.getSessionAttributeMarshaller();
            }

            public Supplier<SC> getSessionContextFactory() {
                return contextFactory;
            }

            public Immutability getImmutability() {
                return Immutability.getDefault();
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return InfinispanSessionManagerFactoryProvider.this.parameters.getSessionAttributePersistenceStrategy();
            }

            public String getDeploymentName() {
                return InfinispanSessionManagerFactoryProvider.this.deploymentName;
            }

            public String getServerName() {
                return InfinispanSessionManagerFactoryProvider.SERVER_NAME;
            }
        };
        final Cache cache = this.manager.getCache(this.deploymentName);
        cache.start();
        this.accept(() -> ((Cache)cache).stop());
        InfinispanSessionManagerFactoryConfiguration infinispan = new InfinispanSessionManagerFactoryConfiguration(){
            final /* synthetic */ CacheContainerCommandDispatcherFactory val$commandDispatcherFactory;
            {
                this.val$commandDispatcherFactory = cacheContainerCommandDispatcherFactory;
            }

            public <K, V> Cache<K, V> getCache() {
                return cache;
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return this.val$commandDispatcherFactory;
            }
        };
        MockSessionSpecificationProvider provider = new MockSessionSpecificationProvider();
        return new InfinispanSessionManagerFactory(managerFactoryConfiguration, (SessionSpecificationProvider)provider, (SessionEventListenerSpecificationProvider)provider, infinispan);
    }
}

