/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.EnumSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.transaction.TransactionMode;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.cache.SessionManagerITCase;
import org.wildfly.clustering.session.cache.SessionManagerParameters;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryProvider;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerParameters;

public class InfinispanSessionManagerITCase
extends SessionManagerITCase<InfinispanSessionManagerParameters> {
    InfinispanSessionManagerITCase() {
        super(InfinispanSessionManagerFactoryProvider::new);
    }

    @ParameterizedTest
    @ArgumentsSource(value=InfinispanSessionManagerArgumentsProvider.class)
    public void basic(InfinispanSessionManagerParameters parameters) throws Exception {
        super.basic((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ConcurrentInfinispanSessionManagerArgumentsProvider.class)
    public void concurrent(InfinispanSessionManagerParameters parameters) throws Exception {
        super.concurrent((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ExpirationInfinispanSessionManagerArgumentsProvider.class)
    public void expiration(InfinispanSessionManagerParameters parameters) throws Exception {
        super.expiration((SessionManagerParameters)parameters);
    }

    static class ExpirationInfinispanSessionManagerArgumentsProvider
    extends InfinispanSessionManagerArgumentsProvider {
        ExpirationInfinispanSessionManagerArgumentsProvider() {
            this.marshallerClass = ProtoStreamTesterFactory.class;
            this.cacheModes = EnumSet.of(CacheMode.DIST_SYNC);
        }
    }

    static class ConcurrentInfinispanSessionManagerArgumentsProvider
    extends InfinispanSessionManagerArgumentsProvider {
        ConcurrentInfinispanSessionManagerArgumentsProvider() {
            this.marshallerClass = ProtoStreamTesterFactory.class;
        }
    }

    static class InfinispanSessionManagerArgumentsProvider
    implements ArgumentsProvider {
        Class<? extends MarshallingTesterFactory> marshallerClass = MarshallingTesterFactory.class;
        Set<TransactionMode> transactionModes = EnumSet.allOf(TransactionMode.class);
        Set<CacheMode> cacheModes = EnumSet.of(CacheMode.DIST_SYNC, CacheMode.REPL_SYNC);

        InfinispanSessionManagerArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            Stream.Builder<Arguments> builder = Stream.builder();
            for (MarshallingTesterFactory marshallingTesterFactory : ServiceLoader.load(this.marshallerClass, this.marshallerClass.getClassLoader())) {
                final ByteBufferMarshaller marshaller = marshallingTesterFactory.getMarshaller();
                for (final SessionAttributePersistenceStrategy strategy : EnumSet.allOf(SessionAttributePersistenceStrategy.class)) {
                    for (final CacheMode cacheMode : this.cacheModes) {
                        for (final TransactionMode transactionMode : this.transactionModes) {
                            builder.add(Arguments.of((Object[])new Object[]{new InfinispanSessionManagerParameters(){

                                public ByteBufferMarshaller getSessionAttributeMarshaller() {
                                    return marshaller;
                                }

                                public SessionAttributePersistenceStrategy getSessionAttributePersistenceStrategy() {
                                    return strategy;
                                }

                                @Override
                                public CacheMode getCacheMode() {
                                    return cacheMode;
                                }

                                @Override
                                public TransactionMode getTransactionMode() {
                                    return transactionMode;
                                }

                                public String toString() {
                                    return Map.ofEntries(Map.entry(ByteBufferMarshaller.class.getSimpleName(), marshaller.toString()), Map.entry(SessionAttributePersistenceStrategy.class.getSimpleName(), strategy.name()), Map.entry(CacheMode.class.getSimpleName(), cacheMode.name()), Map.entry(TransactionMode.class.getSimpleName(), transactionMode.name())).toString();
                                }
                            }}));
                        }
                    }
                }
            }
            return builder.build();
        }
    }
}

