/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded.metadata;

import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.Cache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheEntryComputer;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.coarse.ContextualSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.DefaultImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.DefaultSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.coarse.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.ImmutableSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.MutableSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.MutableSessionMetaDataOffsetValues;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.coarse.SessionMetaDataEntryFunction;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKey;

public class InfinispanSessionMetaDataFactory<C>
implements SessionMetaDataFactory<ContextualSessionMetaDataEntry<C>> {
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<C>> cache;
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<C>> readForUpdateCache;
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<C>> tryReadForUpdateCache;
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<C>> writeOnlyCache;
    private final Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<C>> silentWriteCache;
    private final CacheProperties properties;

    public InfinispanSessionMetaDataFactory(EmbeddedCacheConfiguration configuration) {
        this.cache = configuration.getCache();
        this.readForUpdateCache = configuration.getReadForUpdateCache();
        this.tryReadForUpdateCache = configuration.getTryReadForUpdateCache();
        this.writeOnlyCache = configuration.getWriteOnlyCache();
        this.silentWriteCache = configuration.getSilentWriteCache();
        this.properties = configuration.getCacheProperties();
    }

    public CompletionStage<ContextualSessionMetaDataEntry<C>> createValueAsync(String id, Duration defaultTimeout) {
        DefaultSessionMetaDataEntry entry = new DefaultSessionMetaDataEntry();
        entry.setTimeout(defaultTimeout);
        return this.writeOnlyCache.putAsync((Object)new SessionMetaDataKey(id), (Object)entry).thenApply((Function)org.wildfly.clustering.function.Function.of((Object)entry));
    }

    public CompletionStage<ContextualSessionMetaDataEntry<C>> findValueAsync(String id) {
        return this.readForUpdateCache.getAsync((Object)new SessionMetaDataKey(id));
    }

    public CompletionStage<ContextualSessionMetaDataEntry<C>> tryValueAsync(String id) {
        return this.tryReadForUpdateCache.getAsync((Object)new SessionMetaDataKey(id));
    }

    public CompletionStage<Void> removeAsync(String id) {
        return this.deleteAsync(this.writeOnlyCache, id);
    }

    public CompletionStage<Void> purgeAsync(String id) {
        return this.deleteAsync(this.silentWriteCache, id);
    }

    private CompletionStage<Void> deleteAsync(Cache<SessionMetaDataKey, ContextualSessionMetaDataEntry<C>> cache, String id) {
        return cache.removeAsync((Object)new SessionMetaDataKey(id)).thenAccept((java.util.function.Consumer)Consumer.empty());
    }

    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, ContextualSessionMetaDataEntry<C> entry) {
        return new DefaultImmutableSessionMetaData(entry);
    }

    public InvalidatableSessionMetaData createSessionMetaData(String id, ContextualSessionMetaDataEntry<C> entry) {
        MutableSessionMetaDataOffsetValues delta = this.properties.isTransactional() && entry.isNew() ? null : MutableSessionMetaDataOffsetValues.from(entry);
        CacheEntryMutator mutator = delta != null ? new EmbeddedCacheEntryComputer(this.cache, (Object)new SessionMetaDataKey(id), (BiFunction)new SessionMetaDataEntryFunction(delta)) : CacheEntryMutator.NO_OP;
        return new DefaultSessionMetaData((SessionMetaDataEntry)(delta != null ? new MutableSessionMetaDataEntry((ImmutableSessionMetaDataEntry)entry, delta) : entry), mutator);
    }

    public void close() {
    }
}

