/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded.attributes;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.Cache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheEntryMutatorFactory;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.cache.infinispan.embedded.listener.PostActivateBlockingListener;
import org.wildfly.clustering.cache.infinispan.embedded.listener.PostPassivateBlockingListener;
import org.wildfly.clustering.cache.infinispan.embedded.listener.PrePassivateBlockingListener;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.marshalling.Marshallability;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.CompositeImmutableSession;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.infinispan.embedded.attributes.SessionAttributesKey;
import org.wildfly.clustering.session.infinispan.embedded.metadata.SessionMetaDataKey;

public class CoarseSessionAttributesFactory<C, V>
implements SessionAttributesFactory<C, Map<String, Object>> {
    private static final System.Logger LOGGER = System.getLogger(CoarseSessionAttributesFactory.class.getName());
    private final Cache<SessionAttributesKey, V> cache;
    private final Cache<SessionAttributesKey, V> writeCache;
    private final Cache<SessionAttributesKey, V> silentCache;
    private final Marshaller<Map<String, Object>, V> marshaller;
    private final CacheProperties properties;
    private final Immutability immutability;
    private final CacheEntryMutatorFactory<SessionAttributesKey, V> mutatorFactory;
    private final BiFunction<ImmutableSession, C, SessionActivationNotifier> notifierFactory;
    private final org.wildfly.clustering.function.Function<String, SessionAttributeActivationNotifier> detachedNotifierFactory;
    private final ListenerRegistration evictListenerRegistration;
    private final ListenerRegistration prePassivateListenerRegistration;
    private final ListenerRegistration postActivateListenerRegistration;

    public CoarseSessionAttributesFactory(SessionAttributesFactoryConfiguration<Map<String, Object>, V> configuration, BiFunction<ImmutableSession, C, SessionActivationNotifier> notifierFactory, org.wildfly.clustering.function.Function<String, SessionAttributeActivationNotifier> detachedNotifierFactory, EmbeddedCacheConfiguration infinispan) {
        this.cache = infinispan.getCache();
        this.writeCache = infinispan.getWriteOnlyCache();
        this.silentCache = infinispan.getSilentWriteCache();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = infinispan.getCacheProperties();
        this.mutatorFactory = new EmbeddedCacheEntryMutatorFactory(this.cache, this.properties);
        this.notifierFactory = notifierFactory;
        this.detachedNotifierFactory = detachedNotifierFactory;
        this.prePassivateListenerRegistration = !this.properties.isPersistent() ? new PrePassivateBlockingListener(this.cache, this::prePassivate).register(SessionAttributesKey.class) : null;
        this.postActivateListenerRegistration = !this.properties.isPersistent() ? new PostActivateBlockingListener(this.cache, this::postActivate).register(SessionAttributesKey.class) : null;
        this.evictListenerRegistration = new PostPassivateBlockingListener(infinispan.getCache(), this::cascadeEvict).register(SessionMetaDataKey.class);
    }

    public void close() {
        this.evictListenerRegistration.close();
        if (this.prePassivateListenerRegistration != null) {
            this.prePassivateListenerRegistration.close();
        }
        if (this.postActivateListenerRegistration != null) {
            this.postActivateListenerRegistration.close();
        }
    }

    public CompletionStage<Map<String, Object>> createValueAsync(String id, Void context) {
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        try {
            Object value = this.marshaller.write(attributes);
            return this.writeCache.putAsync((Object)new SessionAttributesKey(id), value).thenApply((Function)org.wildfly.clustering.function.Function.of(attributes));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public CompletionStage<Map<String, Object>> findValueAsync(String id) {
        return this.getValueAsync(id).exceptionally(e -> {
            LOGGER.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
            this.removeAsync(id);
            return null;
        });
    }

    public CompletionStage<Map<String, Object>> tryValueAsync(String id) {
        return this.getValueAsync(id).exceptionally((Function<Throwable, Map<String, Object>>)org.wildfly.clustering.function.Function.of(null));
    }

    private CompletionStage<Map<String, Object>> getValueAsync(String id) {
        return this.cache.getAsync((Object)new SessionAttributesKey(id)).thenApply(value -> {
            try {
                return value != null ? (Map)this.marshaller.read(value) : null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(id, e);
            }
        });
    }

    public CompletionStage<Void> removeAsync(String id) {
        return this.deleteAsync(this.writeCache, id);
    }

    public CompletionStage<Void> purgeAsync(String id) {
        return this.deleteAsync(this.silentCache, id);
    }

    public CompletionStage<Void> deleteAsync(Cache<SessionAttributesKey, V> cache, String id) {
        return cache.removeAsync((Object)new SessionAttributesKey(id)).thenAccept((java.util.function.Consumer)Consumer.empty());
    }

    public Map<String, Object> createImmutableSessionAttributes(String id, Map<String, Object> attributes) {
        return Map.copyOf(attributes);
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, Object> attributes, ImmutableSessionMetaData metaData, C context) {
        try {
            CacheEntryMutator mutator = this.properties.isTransactional() && metaData.isNew() ? CacheEntryMutator.NO_OP : this.mutatorFactory.createMutator((Object)new SessionAttributesKey(id), this.marshaller.write(attributes));
            SessionActivationNotifier notifier = this.properties.isPersistent() ? this.notifierFactory.apply((ImmutableSession)new CompositeImmutableSession(id, metaData, attributes), context) : null;
            return new CoarseSessionAttributes(attributes, mutator, this.properties.isMarshalling() ? this.marshaller : Marshallability.TRUE, this.immutability, notifier);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void cascadeEvict(SessionMetaDataKey key) {
        this.cache.evict((Object)new SessionAttributesKey((String)key.getId()));
    }

    private void prePassivate(SessionAttributesKey key, V value) {
        this.notify(key, value, SessionAttributeActivationNotifier.PRE_PASSIVATE);
    }

    private void postActivate(SessionAttributesKey key, V value) {
        this.notify(key, value, SessionAttributeActivationNotifier.POST_ACTIVATE);
    }

    private void notify(SessionAttributesKey key, V value, BiConsumer<SessionAttributeActivationNotifier, Object> notification) {
        String id = (String)key.getId();
        try (SessionAttributeActivationNotifier notifier = (SessionAttributeActivationNotifier)this.detachedNotifierFactory.apply((Object)id);){
            Map attributes = (Map)this.marshaller.read(value);
            for (Object attributeValue : attributes.values()) {
                notification.accept(notifier, attributeValue);
            }
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

