/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.EnumSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.TransactionMode;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.wildfly.clustering.cache.infinispan.persistence.remote.RemoteCacheStoreConfigurationBuilder;
import org.wildfly.clustering.cache.infinispan.remote.InfinispanServerExtension;
import org.wildfly.clustering.function.Runnable;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.jboss.JBossMarshallingTesterFactory;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.cache.SessionManagerITCase;
import org.wildfly.clustering.session.cache.SessionManagerParameters;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryContext;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerParameters;

public class HotRodStoreSessionManagerITCase
extends SessionManagerITCase<InfinispanSessionManagerParameters> {
    @RegisterExtension
    static final InfinispanServerExtension INFINISPAN = new InfinispanServerExtension();

    HotRodStoreSessionManagerITCase() {
        super(InfinispanSessionManagerFactoryContext::new);
    }

    @ParameterizedTest
    @ArgumentsSource(value=InfinispanInvalidationSessionManagerArgumentsProvider.class)
    public void basic(InfinispanSessionManagerParameters parameters) throws Exception {
        super.basic((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=InfinispanInvalidationSessionManagerArgumentsProvider.class)
    public void concurrent(InfinispanSessionManagerParameters parameters) throws Exception {
        super.concurrent((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=InfinispanInvalidationSessionManagerArgumentsProvider.class)
    public void expiration(InfinispanSessionManagerParameters parameters) throws Exception {
        super.expiration((SessionManagerParameters)parameters);
    }

    static class InfinispanInvalidationSessionManagerArgumentsProvider
    implements ArgumentsProvider {
        Class<? extends MarshallingTesterFactory> marshallerClass = JBossMarshallingTesterFactory.class;
        Set<TransactionMode> transactionModes = EnumSet.of(TransactionMode.NON_TRANSACTIONAL);
        Set<SessionAttributePersistenceStrategy> strategies = EnumSet.allOf(SessionAttributePersistenceStrategy.class);

        InfinispanInvalidationSessionManagerArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            Stream.Builder<Arguments> builder = Stream.builder();
            for (MarshallingTesterFactory marshallingTesterFactory : ServiceLoader.load(this.marshallerClass, this.marshallerClass.getClassLoader())) {
                final ByteBufferMarshaller marshaller = marshallingTesterFactory.getMarshaller();
                for (final SessionAttributePersistenceStrategy strategy : this.strategies) {
                    for (final TransactionMode mode : this.transactionModes) {
                        builder.add(Arguments.of((Object[])new Object[]{new InfinispanSessionManagerParameters(){

                            public ByteBufferMarshaller getSessionAttributeMarshaller() {
                                return marshaller;
                            }

                            public SessionAttributePersistenceStrategy getSessionAttributePersistenceStrategy() {
                                return strategy;
                            }

                            @Override
                            public CacheType getCacheType() {
                                return CacheType.INVALIDATION;
                            }

                            @Override
                            public TransactionMode getTransactionMode() {
                                return mode;
                            }

                            @Override
                            public Runnable persistence(GlobalConfiguration global, PersistenceConfigurationBuilder builder) {
                                Configuration configuration = INFINISPAN.configure(new ConfigurationBuilder().marshaller(global.serialization().marshaller()));
                                RemoteCacheManager container = new RemoteCacheManager(configuration);
                                ((RemoteCacheStoreConfigurationBuilder)((RemoteCacheStoreConfigurationBuilder)((RemoteCacheStoreConfigurationBuilder)builder.persistence().addStore(RemoteCacheStoreConfigurationBuilder.class)).container((RemoteCacheContainer)container).configuration("{\n\t\"local-cache\" : {\n\t\t\"transaction\" : {\n\t\t\t\"mode\" : \"NON_XA\",\n\t\t\t\"locking\" : \"PESSIMISTIC\"\n\t\t}\n\t}\n}").segmented(true)).shared(true)).transactional(false);
                                return () -> ((RemoteCacheManager)container).close();
                            }

                            public String toString() {
                                return Map.ofEntries(Map.entry(ByteBufferMarshaller.class.getSimpleName(), marshaller.toString()), Map.entry(SessionAttributePersistenceStrategy.class.getSimpleName(), strategy.name()), Map.entry(TransactionMode.class.getSimpleName(), mode.name())).toString();
                            }
                        }}));
                    }
                }
            }
            return builder.build();
        }
    }
}

