/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.util.OptionalInt;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.jgroups.Address;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheManagerContext;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheProperties;
import org.wildfly.clustering.context.AbstractContext;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactoryContext;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.MockSessionSpecificationProvider;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.InfinispanSessionManagerParameters;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class InfinispanSessionManagerFactoryContext<C, SC>
extends AbstractContext<SessionManagerFactory<C, SC>> {
    private static final String SERVER_NAME = "server";
    private final SessionManagerFactory<C, SC> factory;

    public InfinispanSessionManagerFactoryContext(final InfinispanSessionManagerParameters parameters, String memberName, final Supplier<SC> contextFactory) {
        try {
            ChannelCommandDispatcherFactoryContext dispatcherFactoryContext = new ChannelCommandDispatcherFactoryContext(parameters.getClusterName(), memberName);
            this.accept(() -> ((Context)dispatcherFactoryContext).close());
            EmbeddedCacheManagerContext managerContext = new EmbeddedCacheManagerContext(((ChannelCommandDispatcherFactory)dispatcherFactoryContext.get()).getGroup().getChannel());
            this.accept(() -> ((Context)managerContext).close());
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.clustering().cacheType(parameters.getCacheType());
            TransactionMode transactionMode = parameters.getTransactionMode();
            builder.transaction().transactionMode(transactionMode);
            if (transactionMode.isTransactional()) {
                builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
                builder.transaction().transactionManagerLookup(EmbeddedTransactionManager::getInstance);
                builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
            }
            String deploymentName = parameters.getDeploymentName();
            if (parameters.getCacheType() == CacheType.INVALIDATION) {
                parameters.persistence(((EmbeddedCacheManager)managerContext.get()).getCacheManagerConfiguration(), builder.persistence());
            }
            Configuration configuration = builder.build();
            EmbeddedCacheProperties properties = new EmbeddedCacheProperties(configuration);
            Assertions.assertThat((boolean)properties.isActive()).isTrue();
            Assertions.assertThat((boolean)properties.isLockOnRead()).isEqualTo(transactionMode.isTransactional());
            Assertions.assertThat((boolean)properties.isLockOnWrite()).isEqualTo(transactionMode.isTransactional());
            Assertions.assertThat((boolean)properties.isMarshalling()).isTrue();
            Assertions.assertThat((boolean)properties.isPersistent()).isTrue();
            Assertions.assertThat((boolean)properties.isTransactional()).isEqualTo(transactionMode.isTransactional());
            ((EmbeddedCacheManager)managerContext.get()).defineConfiguration(deploymentName, configuration);
            this.accept(() -> InfinispanSessionManagerFactoryContext.lambda$new$0((Context)managerContext, deploymentName));
            EmbeddedCacheManagerCommandDispatcherFactory commandDispatcherFactory = new EmbeddedCacheManagerCommandDispatcherFactory((EmbeddedCacheManagerCommandDispatcherFactoryConfiguration)new ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){
                final /* synthetic */ Context val$managerContext;
                final /* synthetic */ Context val$dispatcherFactoryContext;
                {
                    this.val$managerContext = context;
                    this.val$dispatcherFactoryContext = context2;
                }

                public EmbeddedCacheManager getCacheContainer() {
                    return (EmbeddedCacheManager)this.val$managerContext.get();
                }

                public GroupCommandDispatcherFactory<Address, ChannelGroupMember> getCommandDispatcherFactory() {
                    return (GroupCommandDispatcherFactory)this.val$dispatcherFactoryContext.get();
                }
            });
            SessionManagerFactoryConfiguration managerFactoryConfiguration = new SessionManagerFactoryConfiguration<SC>(){

                public OptionalInt getMaxActiveSessions() {
                    return OptionalInt.of(1);
                }

                public ByteBufferMarshaller getMarshaller() {
                    return parameters.getSessionAttributeMarshaller();
                }

                public Supplier<SC> getSessionContextFactory() {
                    return contextFactory;
                }

                public Immutability getImmutability() {
                    return Immutability.getDefault();
                }

                public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                    return parameters.getSessionAttributePersistenceStrategy();
                }

                public String getDeploymentName() {
                    return parameters.getDeploymentName();
                }

                public String getServerName() {
                    return InfinispanSessionManagerFactoryContext.SERVER_NAME;
                }

                public ClassLoader getClassLoader() {
                    return this.getClass().getClassLoader();
                }
            };
            final Cache cache = ((EmbeddedCacheManager)managerContext.get()).getCache(parameters.getDeploymentName());
            cache.start();
            this.accept(() -> ((Cache)cache).stop());
            InfinispanSessionManagerFactoryConfiguration infinispan = new InfinispanSessionManagerFactoryConfiguration(){
                final /* synthetic */ CacheContainerCommandDispatcherFactory val$commandDispatcherFactory;
                {
                    this.val$commandDispatcherFactory = cacheContainerCommandDispatcherFactory;
                }

                public <K, V> Cache<K, V> getCache() {
                    return cache;
                }

                public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                    return this.val$commandDispatcherFactory;
                }
            };
            MockSessionSpecificationProvider provider = new MockSessionSpecificationProvider();
            this.factory = new InfinispanSessionManagerFactory(managerFactoryConfiguration, (SessionSpecificationProvider)provider, (SessionEventListenerSpecificationProvider)provider, infinispan);
            this.accept(() -> this.factory.close());
        }
        catch (Error | RuntimeException e) {
            this.close();
            throw e;
        }
    }

    public SessionManagerFactory<C, SC> get() {
        return this.factory;
    }

    private static /* synthetic */ void lambda$new$0(Context managerContext, String deploymentName) {
        ((EmbeddedCacheManager)managerContext.get()).undefineConfiguration(deploymentName);
    }
}

