/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.embedded;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.session.infinispan.embedded.SessionExpirationScheduler;

public class SessionExpirationSchedulerTestCase {
    @Test
    public void test() throws InterruptedException {
        org.wildfly.clustering.function.Supplier batchFactory = (org.wildfly.clustering.function.Supplier)Mockito.mock(org.wildfly.clustering.function.Supplier.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        Predicate remover = (Predicate)Mockito.mock(Predicate.class);
        ImmutableSessionMetaDataFactory metaDataFactory = (ImmutableSessionMetaDataFactory)Mockito.mock(ImmutableSessionMetaDataFactory.class);
        ImmutableSessionMetaData immortalSessionMetaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ImmutableSessionMetaData expiringSessionMetaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ImmutableSessionMetaData canceledSessionMetaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ImmutableSessionMetaData busySessionMetaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        String immortalSessionId = "immortal";
        String expiringSessionId = "expiring";
        String canceledSessionId = "canceled";
        String busySessionId = "busy";
        Mockito.when((Object)((Batch)batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)immortalSessionMetaData.isImmortal()).thenReturn((Object)true);
        Mockito.when((Object)expiringSessionMetaData.isImmortal()).thenReturn((Object)false);
        Mockito.when((Object)canceledSessionMetaData.isImmortal()).thenReturn((Object)false);
        Mockito.when((Object)busySessionMetaData.isImmortal()).thenReturn((Object)false);
        Mockito.when((Object)expiringSessionMetaData.getTimeout()).thenReturn((Object)Duration.ofMillis(1L));
        Mockito.when((Object)busySessionMetaData.getTimeout()).thenReturn((Object)Duration.ofMillis(1L));
        Mockito.when((Object)canceledSessionMetaData.getTimeout()).thenReturn((Object)Duration.ofSeconds(100L));
        Instant now = Instant.now();
        ((ImmutableSessionMetaData)Mockito.doCallRealMethod().when((Object)expiringSessionMetaData)).getExpirationTime();
        ((ImmutableSessionMetaData)Mockito.doCallRealMethod().when((Object)expiringSessionMetaData)).getLastAccessTime();
        ((ImmutableSessionMetaData)Mockito.doReturn((Object)now).when((Object)expiringSessionMetaData)).getLastAccessEndTime();
        ((ImmutableSessionMetaData)Mockito.doCallRealMethod().when((Object)canceledSessionMetaData)).getLastAccessTime();
        ((ImmutableSessionMetaData)Mockito.doReturn((Object)now).when((Object)canceledSessionMetaData)).getLastAccessEndTime();
        ((ImmutableSessionMetaData)Mockito.doCallRealMethod().when((Object)busySessionMetaData)).getExpirationTime();
        ((ImmutableSessionMetaData)Mockito.doCallRealMethod().when((Object)busySessionMetaData)).getLastAccessTime();
        ((ImmutableSessionMetaData)Mockito.doReturn((Object)now).when((Object)busySessionMetaData)).getLastAccessEndTime();
        ((Predicate)Mockito.doReturn((Object)true).when((Object)remover)).test(expiringSessionId);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)remover)).test(busySessionId);
        try (SessionExpirationScheduler scheduler = new SessionExpirationScheduler("test", (Supplier)org.wildfly.clustering.function.Supplier.of((Object)batch), metaDataFactory, remover, Duration.ZERO);){
            scheduler.schedule((Object)immortalSessionId, (Object)immortalSessionMetaData);
            scheduler.schedule((Object)canceledSessionId, (Object)canceledSessionMetaData);
            scheduler.schedule((Object)expiringSessionId, (Object)expiringSessionMetaData);
            scheduler.schedule((Object)busySessionId, (Object)busySessionMetaData);
            scheduler.cancel((Object)canceledSessionId);
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        ((Predicate)Mockito.verify((Object)remover, (VerificationMode)Mockito.times((int)1))).test(expiringSessionId);
        ((Predicate)Mockito.verify((Object)remover, (VerificationMode)Mockito.times((int)2))).test(busySessionId);
        ((Predicate)Mockito.verify((Object)remover, (VerificationMode)Mockito.never())).test(immortalSessionId);
        ((Predicate)Mockito.verify((Object)remover, (VerificationMode)Mockito.never())).test(canceledSessionId);
        ((Batch)Mockito.verify((Object)batch, (VerificationMode)Mockito.times((int)3))).close();
    }
}

