/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.commons.marshall.Marshaller;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.PassivationListener;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryProvider;
import org.wildfly.clustering.session.container.ContainerFacadeProvider;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerParameters;

public class HotRodSessionManagerFactoryProvider<DC>
implements SessionManagerFactoryProvider<DC, TransactionBatch> {
    private static final String SERVER_NAME = "server";
    private static final String DEPLOYMENT_NAME_PATTERN = "%s-%s.war";
    private final HotRodSessionManagerParameters parameters;
    private final RemoteCacheContainer container;
    private final String deploymentName;

    public HotRodSessionManagerFactoryProvider(HotRodSessionManagerParameters parameters, String memberName) throws Exception {
        this.parameters = parameters;
        this.deploymentName = String.format(DEPLOYMENT_NAME_PATTERN, parameters.getSessionAttributePersistenceStrategy().name(), parameters.getNearCacheMode().name());
        ClassLoader loader = HotRodSessionManagerFactory.class.getClassLoader();
        ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller(ClassLoaderMarshaller.of((ClassLoader)loader), builder -> builder.require(loader));
        this.container = new RemoteCacheManager(parameters.getRemoteCacheContainerConfigurator().configure(new ConfigurationBuilder().marshaller((Marshaller)marshaller).classLoader(loader)), false);
        this.container.start();
        this.container.getConfiguration().addRemoteCache(this.deploymentName, builder -> builder.forceReturnValues(false).nearCacheMode(parameters.getNearCacheMode()).transactionMode(TransactionMode.NONE).templateName(DefaultTemplate.LOCAL));
    }

    public <SC> SessionManagerFactory<DC, SC, TransactionBatch> createSessionManagerFactory(final Supplier<SC> contextFactory, final ContainerFacadeProvider<Map.Entry<ImmutableSession, DC>, DC, PassivationListener<DC>> provider) {
        HotRodSessionManagerFactoryConfiguration managerFactoryConfiguration = new HotRodSessionManagerFactoryConfiguration<Map.Entry<ImmutableSession, DC>, DC, PassivationListener<DC>, SC>(){

            public OptionalInt getMaxActiveSessions() {
                return HotRodSessionManagerFactoryProvider.this.parameters.getNearCacheMode().enabled() ? OptionalInt.of(Short.MAX_VALUE) : OptionalInt.empty();
            }

            public ByteBufferMarshaller getMarshaller() {
                return ProtoStreamTesterFactory.INSTANCE.getMarshaller();
            }

            public Supplier<SC> getSessionContextFactory() {
                return contextFactory;
            }

            public Immutability getImmutability() {
                return Immutability.getDefault();
            }

            public ContainerFacadeProvider<Map.Entry<ImmutableSession, DC>, DC, PassivationListener<DC>> getContainerFacadeProvider() {
                return provider;
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return HotRodSessionManagerFactoryProvider.this.parameters.getSessionAttributePersistenceStrategy();
            }

            public String getDeploymentName() {
                return HotRodSessionManagerFactoryProvider.this.deploymentName;
            }

            public String getServerName() {
                return HotRodSessionManagerFactoryProvider.SERVER_NAME;
            }

            public <K, V> RemoteCache<K, V> getCache() {
                return HotRodSessionManagerFactoryProvider.this.container.getCache(this.getDeploymentName());
            }

            public int getExpirationThreadPoolSize() {
                return 1;
            }
        };
        return new HotRodSessionManagerFactory(managerFactoryConfiguration);
    }

    public void close() throws Exception {
        try {
            this.container.getConfiguration().removeRemoteCache(this.deploymentName);
        }
        finally {
            this.container.stop();
        }
    }
}

