/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.Remover;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionAttributes;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.CompositeSessionFactory;
import org.wildfly.clustering.session.cache.attributes.ImmutableSessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.metadata.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionMetaDataEntry;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionFactoryConfiguration;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionAccessMetaDataKey;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionCreationMetaDataKey;

@ClientListener
public class HotRodSessionFactory<MC, AV, LC>
extends CompositeSessionFactory<MC, SessionMetaDataEntry<LC>, AV, LC>
implements Registrar<Consumer<ImmutableSession>> {
    private static final Logger LOGGER = Logger.getLogger(HotRodSessionFactory.class);
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(HotRodSessionFactory.class);
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<LC>> creationMetaDataCache;
    private final Flag[] forceReturnFlags;
    private final ImmutableSessionMetaDataFactory<SessionMetaDataEntry<LC>> metaDataFactory;
    private final ImmutableSessionAttributesFactory<AV> attributesFactory;
    private final Remover<String> attributesRemover;
    private final Collection<Consumer<ImmutableSession>> listeners = new CopyOnWriteArraySet<Consumer<ImmutableSession>>();
    private final ExecutorService executor;

    public HotRodSessionFactory(HotRodSessionFactoryConfiguration config, SessionMetaDataFactory<SessionMetaDataEntry<LC>> metaDataFactory, SessionAttributesFactory<MC, AV> attributesFactory, Supplier<LC> localContextFactory) {
        super(metaDataFactory, attributesFactory, localContextFactory);
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.attributesRemover = attributesFactory;
        this.creationMetaDataCache = config.getCache();
        this.forceReturnFlags = config.getForceReturnFlags();
        this.executor = Executors.newFixedThreadPool(config.getExpirationThreadPoolSize(), THREAD_FACTORY);
        this.creationMetaDataCache.addClientListener((Object)this);
    }

    public void close() {
        this.creationMetaDataCache.removeClientListener((Object)this);
        AccessController.doPrivileged(DefaultExecutorService.shutdown((ExecutorService)this.executor));
        try {
            this.executor.awaitTermination(this.creationMetaDataCache.getRemoteCacheContainer().getConfiguration().transactionTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @ClientCacheEntryExpired
    public void expired(ClientCacheEntryExpiredEvent<SessionAccessMetaDataKey> event) {
        final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<LC>> creationMetaDataCache = this.creationMetaDataCache;
        final Flag[] forceReturnFlags = this.forceReturnFlags;
        final ImmutableSessionMetaDataFactory<SessionMetaDataEntry<LC>> metaDataFactory = this.metaDataFactory;
        final ImmutableSessionAttributesFactory<AV> attributesFactory = this.attributesFactory;
        final Remover<String> attributesRemover = this.attributesRemover;
        final Collection<Consumer<ImmutableSession>> listeners = this.listeners;
        final String id = (String)((SessionAccessMetaDataKey)((Object)event.getKey())).getId();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Object attributesValue;
                SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)creationMetaDataCache.withFlags(forceReturnFlags).remove((Object)new SessionCreationMetaDataKey(id));
                if (creationMetaDataEntry != null && (attributesValue = attributesFactory.findValue((Object)id)) != null) {
                    DefaultSessionAccessMetaDataEntry accessMetaData = new DefaultSessionAccessMetaDataEntry();
                    Duration lastAccess = Duration.ofSeconds(1L);
                    Duration sinceCreation = Duration.between(creationMetaDataEntry.getCreationTime(), Instant.now()).minus(creationMetaDataEntry.getTimeout()).minus(lastAccess);
                    accessMetaData.setLastAccessDuration(sinceCreation, lastAccess);
                    ImmutableSessionMetaData metaData = metaDataFactory.createImmutableSessionMetaData(id, (Object)new DefaultSessionMetaDataEntry(creationMetaDataEntry, (SessionAccessMetaDataEntry)accessMetaData));
                    ImmutableSessionAttributes attributes = attributesFactory.createImmutableSessionAttributes(id, attributesValue);
                    ImmutableSession session = HotRodSessionFactory.this.createImmutableSession(id, metaData, attributes);
                    LOGGER.tracef("Session %s has expired.", (Object)id);
                    for (Consumer listener : listeners) {
                        listener.accept(session);
                    }
                    attributesRemover.remove((Object)id);
                }
            }
        };
        this.executor.submit(task);
    }

    public Registration register(Consumer<ImmutableSession> listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }
}

