/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote.user;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.function.Functions;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheEntryMutator;
import org.wildfly.clustering.session.cache.user.MutableUserSessions;
import org.wildfly.clustering.session.cache.user.UserSessionsFactory;
import org.wildfly.clustering.session.infinispan.remote.user.UserSessionsKey;
import org.wildfly.clustering.session.user.UserSessions;

public class HotRodUserSessionsFactory<D, S>
implements UserSessionsFactory<Map<D, S>, D, S> {
    private final RemoteCache<UserSessionsKey, Map<D, S>> cache;
    private final Flag[] ignoreReturnFlags;

    public HotRodUserSessionsFactory(RemoteCacheConfiguration configuration) {
        this.cache = configuration.getCache();
        this.ignoreReturnFlags = configuration.getIgnoreReturnFlags();
    }

    public UserSessions<D, S> createUserSessions(String id, Map<D, S> value) {
        UserSessionsKey key = new UserSessionsKey(id);
        RemoteCacheEntryMutator mutator = new RemoteCacheEntryMutator(this.cache, this.ignoreReturnFlags, (Object)key, value);
        return new MutableUserSessions(value, (CacheEntryMutator)mutator);
    }

    public CompletionStage<Map<D, S>> createValueAsync(String id, Void context) {
        ConcurrentHashMap sessions = new ConcurrentHashMap();
        return this.cache.withFlags(this.ignoreReturnFlags).putAsync((Object)new UserSessionsKey(id), sessions).thenApply(Functions.constantFunction(sessions));
    }

    public CompletionStage<Map<D, S>> findValueAsync(String id) {
        return this.cache.getAsync((Object)new UserSessionsKey(id));
    }

    public CompletionStage<Void> removeAsync(String id) {
        return this.cache.withFlags(this.ignoreReturnFlags).removeAsync((Object)new UserSessionsKey(id)).thenAccept(org.wildfly.common.function.Functions.discardingConsumer());
    }
}

