/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.EnumSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.wildfly.clustering.cache.infinispan.remote.InfinispanServerExtension;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheContainerConfigurator;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.cache.SessionManagerITCase;
import org.wildfly.clustering.session.cache.SessionManagerParameters;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactoryProvider;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerParameters;

public class HotRodSessionManagerITCase
extends SessionManagerITCase<HotRodSessionManagerParameters> {
    @RegisterExtension
    static final InfinispanServerExtension INFINISPAN = new InfinispanServerExtension();

    HotRodSessionManagerITCase() {
        super(HotRodSessionManagerFactoryProvider::new);
    }

    @ParameterizedTest
    @ArgumentsSource(value=HotRodSessionManagerArgumentsProvider.class)
    public void basic(HotRodSessionManagerParameters parameters) throws Exception {
        super.basic((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=HotRodSessionManagerArgumentsProvider.class)
    public void concurrent(HotRodSessionManagerParameters parameters) throws Exception {
        super.concurrent((SessionManagerParameters)parameters);
    }

    @ParameterizedTest
    @ArgumentsSource(value=HotRodSessionManagerArgumentsProvider.class)
    public void expiration(HotRodSessionManagerParameters parameters) throws Exception {
        super.expiration((SessionManagerParameters)parameters);
    }

    static class HotRodSessionManagerArgumentsProvider
    implements ArgumentsProvider {
        Class<? extends MarshallingTesterFactory> marshallerClass;
        Set<NearCacheMode> nearCacheModes = EnumSet.of(NearCacheMode.DISABLED);

        HotRodSessionManagerArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            Stream.Builder<Arguments> builder = Stream.builder();
            for (MarshallingTesterFactory factory : ServiceLoader.load(MarshallingTesterFactory.class, MarshallingTesterFactory.class.getClassLoader())) {
                final ByteBufferMarshaller marshaller = factory.getMarshaller();
                for (final NearCacheMode nearCacheMode : this.nearCacheModes) {
                    for (final SessionAttributePersistenceStrategy strategy : EnumSet.allOf(SessionAttributePersistenceStrategy.class)) {
                        builder.add(Arguments.of((Object[])new Object[]{new HotRodSessionManagerParameters(){

                            public ByteBufferMarshaller getSessionAttributeMarshaller() {
                                return marshaller;
                            }

                            public SessionAttributePersistenceStrategy getSessionAttributePersistenceStrategy() {
                                return strategy;
                            }

                            @Override
                            public NearCacheMode getNearCacheMode() {
                                return nearCacheMode;
                            }

                            @Override
                            public RemoteCacheContainerConfigurator getRemoteCacheContainerConfigurator() {
                                return INFINISPAN;
                            }

                            public String toString() {
                                return Map.of(ByteBufferMarshaller.class.getSimpleName(), marshaller.toString(), SessionAttributePersistenceStrategy.class.getSimpleName(), strategy).toString();
                            }
                        }}));
                    }
                }
            }
            return builder.build();
        }
    }
}

