/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote.user;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheEntryMutator;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.session.cache.user.MutableUserSessions;
import org.wildfly.clustering.session.cache.user.UserSessionsFactory;
import org.wildfly.clustering.session.infinispan.remote.user.UserSessionsKey;
import org.wildfly.clustering.session.user.UserSessions;

public class HotRodUserSessionsFactory<D, S>
implements UserSessionsFactory<Map<D, S>, D, S> {
    private final RemoteCache<UserSessionsKey, Map<D, S>> readCache;
    private final RemoteCache<UserSessionsKey, Map<D, S>> writeCache;

    public HotRodUserSessionsFactory(RemoteCacheConfiguration configuration) {
        this.readCache = configuration.getCache();
        this.writeCache = configuration.getIgnoreReturnCache();
    }

    public UserSessions<D, S> createUserSessions(String id, Map<D, S> value) {
        UserSessionsKey key = new UserSessionsKey(id);
        RemoteCacheEntryMutator mutator = new RemoteCacheEntryMutator(this.writeCache, (Object)key, value);
        return new MutableUserSessions(value, (CacheEntryMutator)mutator);
    }

    public CompletionStage<Map<D, S>> createValueAsync(String id, Void context) {
        ConcurrentHashMap sessions = new ConcurrentHashMap();
        return this.writeCache.putAsync((Object)new UserSessionsKey(id), sessions).thenApply((Function)org.wildfly.clustering.function.Function.of(sessions));
    }

    public CompletionStage<Map<D, S>> findValueAsync(String id) {
        return this.readCache.getAsync((Object)new UserSessionsKey(id));
    }

    public CompletionStage<Void> removeAsync(String id) {
        return this.writeCache.removeAsync((Object)new UserSessionsKey(id)).thenAccept((java.util.function.Consumer)Consumer.empty());
    }
}

