/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote.metadata;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.offset.OffsetValue;
import org.wildfly.clustering.server.offset.Value;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.fine.CompositeImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.CompositeSessionMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.ImmutableSessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionAccessMetaDataOffsetValues;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionAccessMetaDataValues;
import org.wildfly.clustering.session.cache.metadata.fine.MutableSessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntryFunction;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaData;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntryFunction;
import org.wildfly.clustering.session.cache.metadata.fine.SessionMetaDataEntry;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionAccessMetaDataKey;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionCreationMetaDataKey;

public class HotRodSessionMetaDataFactory<C>
implements SessionMetaDataFactory<SessionMetaDataEntry<C>>,
BiFunction<SessionCreationMetaDataEntry<C>, SessionAccessMetaDataEntry, SessionMetaDataEntry<C>> {
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<C>> readCreationMetaDataCache;
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<C>> writeCreationMetaDataCache;
    private final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaDataEntry> readAccessMetaDataCache;
    private final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaDataEntry> writeAccessMetaDataCache;
    private final CacheEntryMutatorFactory<SessionCreationMetaDataKey, OffsetValue<Duration>> creationMetaDataMutatorFactory;
    private final CacheEntryMutatorFactory<SessionAccessMetaDataKey, MutableSessionAccessMetaDataOffsetValues> accessMetaDataMutatorFactory;

    public HotRodSessionMetaDataFactory(RemoteCacheConfiguration configuration) {
        this.readCreationMetaDataCache = configuration.getReadForUpdateCache();
        this.writeCreationMetaDataCache = configuration.getIgnoreReturnCache();
        this.readAccessMetaDataCache = configuration.getCache();
        this.writeAccessMetaDataCache = configuration.getIgnoreReturnCache();
        this.creationMetaDataMutatorFactory = configuration.getCacheEntryMutatorFactory(SessionCreationMetaDataEntryFunction::new);
        this.accessMetaDataMutatorFactory = configuration.getCacheEntryMutatorFactory(SessionAccessMetaDataEntryFunction::new);
    }

    public CompletionStage<SessionMetaDataEntry<C>> createValueAsync(String id, Duration defaultTimeout) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        DefaultSessionCreationMetaDataEntry creationMetaData = new DefaultSessionCreationMetaDataEntry();
        creationMetaData.setTimeout(defaultTimeout);
        DefaultSessionAccessMetaDataEntry accessMetaData = new DefaultSessionAccessMetaDataEntry();
        CompletableFuture creationStage = this.writeCreationMetaDataCache.putAsync((Object)creationMetaDataKey, (Object)creationMetaData);
        CompletableFuture accessStage = this.writeAccessMetaDataCache.putAsync((Object)accessMetaDataKey, (Object)accessMetaData, 0L, TimeUnit.SECONDS, defaultTimeout.getSeconds(), TimeUnit.SECONDS);
        return CompletableFuture.allOf(creationStage, accessStage).thenApply((Function)org.wildfly.clustering.function.Function.of((Object)new DefaultSessionMetaDataEntry((SessionCreationMetaDataEntry)creationMetaData, (SessionAccessMetaDataEntry)accessMetaData)));
    }

    public CompletionStage<SessionMetaDataEntry<C>> findValueAsync(String id) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        return this.readCreationMetaDataCache.getAsync((Object)creationMetaDataKey).thenCombine((CompletionStage)this.readAccessMetaDataCache.getAsync((Object)accessMetaDataKey), (java.util.function.BiFunction)((Object)this));
    }

    public SessionMetaDataEntry<C> apply(SessionCreationMetaDataEntry<C> creationMetaData, SessionAccessMetaDataEntry accessMetaData) {
        return creationMetaData != null && accessMetaData != null ? new DefaultSessionMetaDataEntry(creationMetaData, accessMetaData) : null;
    }

    public CompletionStage<Void> removeAsync(String id) {
        CompletableFuture creationMetaData = this.writeCreationMetaDataCache.removeAsync((Object)new SessionCreationMetaDataKey(id));
        CompletableFuture accessMetaData = this.writeAccessMetaDataCache.removeAsync((Object)new SessionAccessMetaDataKey(id));
        return CompletableFuture.allOf(creationMetaData, accessMetaData).thenAccept((java.util.function.Consumer)Consumer.empty());
    }

    public InvalidatableSessionMetaData createSessionMetaData(String id, SessionMetaDataEntry<C> entry) {
        OffsetValue timeoutOffset = OffsetValue.from((Duration)entry.getCreationMetaDataEntry().getTimeout());
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData((ImmutableSessionCreationMetaData)entry.getCreationMetaDataEntry(), (Value)timeoutOffset);
        MutableSessionAccessMetaDataOffsetValues values = MutableSessionAccessMetaDataOffsetValues.from((ImmutableSessionAccessMetaData)entry.getAccessMetaDataEntry());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData((ImmutableSessionAccessMetaData)entry.getAccessMetaDataEntry(), (MutableSessionAccessMetaDataValues)values);
        CacheEntryMutator creationMetaDataMutator = this.creationMetaDataMutatorFactory.createMutator((Object)new SessionCreationMetaDataKey(id), (Object)timeoutOffset);
        CacheEntryMutator accessMetaDataMutator = this.accessMetaDataMutatorFactory.createMutator((Object)new SessionAccessMetaDataKey(id), (Object)values).withMaxIdle(() -> ((SessionCreationMetaData)creationMetaData).getTimeout());
        CacheEntryMutator mutator = CacheEntryMutator.of(List.of(creationMetaDataMutator, accessMetaDataMutator));
        return new CompositeSessionMetaData((SessionCreationMetaData)creationMetaData, (SessionAccessMetaData)accessMetaData, (Runnable)mutator);
    }

    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, SessionMetaDataEntry<C> entry) {
        return new CompositeImmutableSessionMetaData((ImmutableSessionCreationMetaData)entry.getCreationMetaDataEntry(), (ImmutableSessionAccessMetaData)entry.getAccessMetaDataEntry());
    }

    public void close() {
    }
}

