/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.transaction.lookup.RemoteTransactionManagerLookup;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.wildfly.clustering.cache.infinispan.marshalling.MediaTypes;
import org.wildfly.clustering.cache.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.context.AbstractContext;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.MockSessionSpecificationProvider;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerFactory;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManagerParameters;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class HotRodSessionManagerFactoryContext<C, SC>
extends AbstractContext<SessionManagerFactory<C, SC>> {
    private static final String SERVER_NAME = "server";
    private final SessionManagerFactory<C, SC> factory;

    public HotRodSessionManagerFactoryContext(final HotRodSessionManagerParameters parameters, String memberName, final Supplier<SC> contextFactory) {
        ClassLoader loader = HotRodSessionManagerFactory.class.getClassLoader();
        UserMarshaller marshaller = new UserMarshaller((Supplier)MediaTypes.WILDFLY_PROTOSTREAM, (ByteBufferMarshaller)new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)((SerializationContextBuilder)SerializationContextBuilder.newInstance((ClassLoaderMarshaller)ClassLoaderMarshaller.of((ClassLoader)loader)).load(loader)).build()));
        RemoteCacheManager container = new RemoteCacheManager(parameters.getRemoteCacheContainerConfigurator().configure(new ConfigurationBuilder().marshaller((Marshaller)marshaller)));
        this.accept(() -> ((RemoteCacheManager)container).close());
        Configuration configuration = container.getConfiguration();
        Consumer<RemoteCacheConfigurationBuilder> configurator = builder -> builder.configuration("{\n\t\"local-cache\" : {\n\t\t\"expiration\" : {\n\t\t\t\"interval\" : 1000\n\t\t},\n\t\t\"transaction\" : {\n\t\t\t\"mode\" : \"NON_XA\",\n\t\t\t\"locking\" : \"PESSIMISTIC\"\n\t\t}\n\t}\n}").forceReturnValues(false).nearCacheMode(parameters.getNearCacheMode()).transactionMode(TransactionMode.NONE).transactionManagerLookup(RemoteTransactionManagerLookup.getInstance());
        String deploymentName = parameters.getDeploymentName();
        configuration.addRemoteCache(deploymentName, configurator);
        this.accept(() -> configuration.removeRemoteCache(deploymentName));
        SessionManagerFactoryConfiguration managerFactoryConfiguration = new SessionManagerFactoryConfiguration<SC>(){

            public OptionalInt getMaxActiveSessions() {
                return parameters.getNearCacheMode().enabled() ? OptionalInt.of(Short.MAX_VALUE) : OptionalInt.empty();
            }

            public ByteBufferMarshaller getMarshaller() {
                return parameters.getSessionAttributeMarshaller();
            }

            public Supplier<SC> getSessionContextFactory() {
                return contextFactory;
            }

            public Immutability getImmutability() {
                return Immutability.getDefault();
            }

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return parameters.getSessionAttributePersistenceStrategy();
            }

            public String getDeploymentName() {
                return parameters.getDeploymentName();
            }

            public String getServerName() {
                return HotRodSessionManagerFactoryContext.SERVER_NAME;
            }

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }
        };
        final RemoteCache cache = container.getCache(parameters.getDeploymentName());
        cache.start();
        this.accept(() -> ((RemoteCache)cache).stop());
        RemoteCacheConfiguration hotrod = new RemoteCacheConfiguration(){

            public <CK, CV> RemoteCache<CK, CV> getCache() {
                return cache;
            }
        };
        MockSessionSpecificationProvider provider = new MockSessionSpecificationProvider();
        this.factory = new HotRodSessionManagerFactory(managerFactoryConfiguration, (SessionSpecificationProvider)provider, (SessionEventListenerSpecificationProvider)provider, hotrod);
        this.accept(() -> this.factory.close());
    }

    public SessionManagerFactory<C, SC> get() {
        return this.factory;
    }
}

