/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.wildfly.clustering.cache.caffeine.CacheConfiguration;
import org.wildfly.clustering.cache.caffeine.CacheFactory;
import org.wildfly.clustering.cache.infinispan.remote.near.CaffeineNearCache;
import org.wildfly.clustering.server.eviction.EvictionConfiguration;
import org.wildfly.clustering.session.infinispan.remote.attributes.SessionAttributesKey;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionAccessMetaDataKey;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionCreationMetaDataKey;

public class SessionManagerNearCacheFactory
implements NearCacheFactory {
    private final EvictionConfiguration configuration;

    public SessionManagerNearCacheFactory(EvictionConfiguration configuration) {
        this.configuration = configuration;
    }

    public <K, V> NearCache<K, V> createNearCache(NearCacheConfiguration config, final BiConsumer<K, MetadataValue<V>> removedConsumer) {
        AtomicReference<Cache> reference;
        CacheConfiguration.Builder builder;
        block3: {
            Optional idleThreshold;
            OptionalInt maxSize;
            block2: {
                builder = CacheConfiguration.builder();
                maxSize = this.configuration.getSizeThreshold();
                idleThreshold = this.configuration.getIdleThreshold();
                reference = new AtomicReference<Cache>();
                if (maxSize.isPresent()) break block2;
                if (!idleThreshold.isPresent()) break block3;
            }
            maxSize.ifPresent(arg_0 -> ((CacheConfiguration.Builder)builder).withMaxWeight(arg_0));
            idleThreshold.ifPresent(arg_0 -> ((CacheConfiguration.Builder)builder).evictAfter(arg_0));
            builder.evictableWhen(SessionCreationMetaDataKey.class::isInstance);
            builder.whenRemoved(new RemovalListener<K, MetadataValue<V>>(this){
                final /* synthetic */ SessionManagerNearCacheFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void onRemoval(K key, MetadataValue<V> value, RemovalCause cause) {
                    if (cause != RemovalCause.REPLACED) {
                        removedConsumer.accept(key, value);
                        if ((cause == RemovalCause.EXPIRED || cause == RemovalCause.SIZE) && key instanceof SessionCreationMetaDataKey) {
                            SessionCreationMetaDataKey creationMetaDataKey = (SessionCreationMetaDataKey)((Object)key);
                            String id = (String)creationMetaDataKey.getId();
                            ((Cache)reference.get()).invalidateAll(List.of(new SessionAccessMetaDataKey(id), new SessionAttributesKey(id)));
                        }
                    }
                }
            });
        }
        Cache cache = new CacheFactory().apply(builder.build());
        reference.set(cache);
        return new CaffeineNearCache(cache);
    }
}

